package ru.yandex.direct.jobs.uac.model

import java.sql.ResultSet
import ru.yandex.direct.core.entity.uac.model.ShopInShopBusiness
import ru.yandex.direct.core.entity.uac.model.Source

data class ShopInShopBusinessRow(
    val businessId: Long,
    val feedUrl: String,
    val counterId: Long
) {
    companion object {
        fun fromResultSet(rs: ResultSet): ShopInShopBusinessRow {
            return ShopInShopBusinessRow(
                rs.getLong("business_id"),
                rs.getString("feed_url"),
                rs.getLong("counter_id")
            )
        }
    }

    fun toShopInShopBusiness(source: Source): ShopInShopBusiness {
        return ShopInShopBusiness()
            .withSource(source)
            .withBusinessId(businessId)
            .withFeedUrl(feedUrl)
            .withCounterId(counterId)
    }
}
