package ru.yandex.direct.jobs.uac.model

import ru.yandex.direct.core.entity.campaign.model.CommonCampaign
import ru.yandex.direct.core.entity.client.model.Client
import ru.yandex.direct.core.entity.uac.model.request.UacAdGroupBrief
import ru.yandex.direct.core.entity.uac.model.request.createBrief
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbCampaign
import ru.yandex.direct.core.grut.api.AdGroupBriefGrutModel
import ru.yandex.direct.dbutil.model.ClientId

data class UpdateAdsContainer(
    val operatorUid: Long,
    val client: Client,
    val brief: UacAdGroupBrief, // групповая заявка, совмещенная с заявкой на кампанию
    val campaign: CommonCampaign,
) {
    fun getClientId(): ClientId = ClientId.fromLong(client.clientId)
}

fun createUpdateAdsContainers(
    operatorUid: Long,
    client: Client,
    uacCampaign: UacYdbCampaign,
    uacAdGroupBrief: List<AdGroupBriefGrutModel>?,
    campaign: CommonCampaign,
): List<UpdateAdsContainer> {
    val adGroupBrief =
        if (uacAdGroupBrief.isNullOrEmpty()) listOf<AdGroupBriefGrutModel?>(null)
        else uacAdGroupBrief

    return adGroupBrief
        .map {
            UpdateAdsContainer(
                operatorUid,
                client,
                createBrief(uacCampaign, it),
                campaign,
            )
        }
}
