package ru.yandex.direct.jobs.uac.service

import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.uac.model.direct_content.DirectContentStatus
import ru.yandex.direct.core.entity.uac.model.direct_content.DirectContentType
import ru.yandex.direct.core.entity.uac.repository.ydb.UacYdbContentRepository
import ru.yandex.direct.core.entity.uac.repository.ydb.UacYdbDirectContentRepository
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbCampaignContent
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbDirectContent

@Service
class Html5ContentCreateJobService(
    private val uacYdbContentRepository: UacYdbContentRepository,
    private val uacYdbDirectContentRepository: UacYdbDirectContentRepository,
) {

    fun createUacHtml5Contents(
        campaignContents: List<UacYdbCampaignContent>,
    ) {
        val contentIds = campaignContents
            .mapNotNull { it.contentId }
            .toSet()

        val contentIdToUacContent = uacYdbContentRepository.getContents(contentIds)
            .associateBy { it.id }

        val uacDirectContents = campaignContents.map { uacCampaignContent ->
            val uacContent = contentIdToUacContent[uacCampaignContent.contentId]
                ?: throw IllegalStateException("Uac content not found by content id: $uacCampaignContent.contentId")

            UacYdbDirectContent(
                id = uacCampaignContent.id,
                status = DirectContentStatus.CREATED,
                type = DirectContentType.HTML5,
                directImageHash = null,
                // Для обратной совместимости стоит оставить, но надо подумать, как от этого избавиться
                directVideoId = uacContent.meta["creative_id"].toString().toLongOrNull(),
                directHtml5Id = uacContent.meta["creative_id"].toString().toLongOrNull(),
            )
        }

        uacYdbDirectContentRepository.addDirectContent(uacDirectContents)
    }
}
