package ru.yandex.direct.jobs.uac.service

import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbContent
import ru.yandex.direct.core.entity.uac.service.AssetPatch
import ru.yandex.direct.core.entity.uac.service.BaseUacContentService
import ru.yandex.direct.core.entity.uac.service.GrutUacContentService
import ru.yandex.direct.core.entity.uac.service.UacContentService
import ru.yandex.direct.model.KtModelChanges
import ru.yandex.direct.utils.JsonUtils.toJson
import ru.yandex.grut.objects.proto.Asset

abstract class UacContentJobService(
    private val uacContentService: BaseUacContentService,
) {
    abstract fun updateVideoMeta(clientId: String, contentId: String, meta: Map<String, Any?>)
    fun getContent(contentId: String) = uacContentService.getYdbContent(contentId)
}

@Service
class GrutUacContentJobService(
    private val grutUacContentService: GrutUacContentService,
) : UacContentJobService(grutUacContentService) {
    override fun updateVideoMeta(clientId: String, contentId: String, meta: Map<String, Any?>) {

        val assetSpecPatch = Asset.TAssetSpec.newBuilder().apply {
            video = Asset.TVideoAsset.newBuilder().apply {
                mdsInfo = Asset.TMdsInfo.newBuilder().apply {
                    this.meta = toJson(meta)
                }.build()
            }.build()
        }.build()

        grutUacContentService.updateAssets(listOf(
            AssetPatch(id = contentId, spec = assetSpecPatch, setPaths = listOf("/spec/video/mdsInfo/meta"))
        ))
    }
}

@Service
class YdbUacContentJobService(
    private val ydbUacContentService: UacContentService
) : UacContentJobService(ydbUacContentService) {
    override fun updateVideoMeta(clientId: String, contentId: String, meta: Map<String, Any?>) {
        val ktModelChanges = KtModelChanges<String, UacYdbContent>(contentId)
        ktModelChanges.process(UacYdbContent::meta, meta)
        ydbUacContentService.updateContent(ktModelChanges)
    }

}

