package ru.yandex.direct.jobs.uac.service

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.uac.service.UacDbDefineService

@Component
class UacJobServiceHolder(
    private val uacDbDefineService: UacDbDefineService,
    private val grutUacBannerJobService: GrutUacBannerJobService,
    private val ydbUacBannerJobService: YdbUacBannerJobService,
    private val grutUacAdGroupJobService: GrutUacAdGroupJobService,
    private val ydbUacAdGroupJobService: YdbUacAdGroupJobService,
    private val grutBannerCreateJobService: GrutBannerCreateJobService,
    private val ydbBannerCreateJobService: YdbBannerCreateJobService,
    private val grutUacContentJobService: GrutUacContentJobService,
    private val ydbUacContentJobService: YdbUacContentJobService,
) {
    fun getUacBannerJobService(campaignId: String) =
        if (uacDbDefineService.useGrut(campaignId)) grutUacBannerJobService else ydbUacBannerJobService

    fun getUacAdGroupJobService(campaignId: String) =
        getUacAdGroupJobService(uacDbDefineService.useGrut(campaignId))

    fun getUacAdGroupJobService(useGrut: Boolean) =
        if (useGrut) grutUacAdGroupJobService else ydbUacAdGroupJobService

    fun getBannerCreateJobService(campaignId: String) =
        getBannerCreateJobService(uacDbDefineService.useGrut(campaignId))

    fun getBannerCreateJobService(useGrut: Boolean) =
        if (useGrut) grutBannerCreateJobService else ydbBannerCreateJobService

    fun getUacContentJobService(useGrut: Boolean) =
        if (useGrut) grutUacContentJobService else ydbUacContentJobService
}
