package ru.yandex.direct.jobs.uac.service

import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.uac.model.direct_content.DirectContentStatus
import ru.yandex.direct.core.entity.uac.model.direct_content.DirectContentType
import ru.yandex.direct.core.entity.uac.repository.ydb.UacYdbContentRepository
import ru.yandex.direct.core.entity.uac.repository.ydb.UacYdbDirectContentRepository
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbCampaignContent
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbDirectContent

@Service
class VideoContentCreateJobService(
    private val uacYdbContentRepository: UacYdbContentRepository,
    private val uacYdbDirectContentRepository: UacYdbDirectContentRepository,
) {

    fun createUacVideoContents(
        campaignContents: List<UacYdbCampaignContent>,
    ) {
        val contentIds = campaignContents
            .mapNotNull { it.contentId }
            .toSet()

        val contentIdToUacContent = uacYdbContentRepository.getContents(contentIds)
            .associateBy { it.id }

        val uacDirectContents = campaignContents.map { uacCampaignContent ->
            val uacContent = contentIdToUacContent[uacCampaignContent.contentId]
                ?: throw IllegalStateException("Uac content not found by content id: $uacCampaignContent.contentId")

            val isVideoNonSkippable = uacContent.meta["creative_type"]?.toString()?.lowercase() == "non_skippable_cpm"

            UacYdbDirectContent(
                id = uacCampaignContent.id,
                status = DirectContentStatus.CREATED,
                type = if (isVideoNonSkippable) DirectContentType.NON_SKIPPABLE_VIDEO else DirectContentType.VIDEO,
                directImageHash = null,
                directVideoId = uacContent.meta["creative_id"].toString().toLongOrNull(),
                directHtml5Id = null,
            )
        }

        uacYdbDirectContentRepository.addDirectContent(uacDirectContents)
    }
}
