package ru.yandex.direct.jobs.urlmonitoring;

import java.util.regex.Pattern;

import static ru.yandex.direct.validation.constraint.StringConstraints.DOMAIN_PATTERN;
import static ru.yandex.direct.validation.constraint.StringConstraints.PORT_PATTERN;
import static ru.yandex.direct.validation.constraint.StringConstraints.PROTOCOL_PATTERN;

class UrlMonitoringUtils {
    static final Pattern URL_PATTERN = Pattern.compile("^"
                    + PROTOCOL_PATTERN
                    + "?"
                    + DOMAIN_PATTERN
                    + PORT_PATTERN
                    + "([/?#].*)?", // path and query params part
            Pattern.UNICODE_CHARACTER_CLASS);

    static final String URL_MONITORING_SOLOMON_LABEL = "bsCheckUrlAvailability";
}
