package ru.yandex.direct.jobs.urlmonitoring.model;

import java.util.Set;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Событие URL мониторинга
 */
@SuppressWarnings("WeakerAccess")
public class UrlMonitoringEvent {

    private Integer oldStatus;
    private Integer newStatus;

    private Set<String> sources;

    private String url;
    private Long updated;

    @JsonProperty("old")
    public Integer getOldStatus() {
        return oldStatus;
    }

    @JsonProperty("new")
    public Integer getNewStatus() {
        return newStatus;
    }

    @JsonProperty("sources")
    public Set<String> getSources() {
        return sources;
    }

    @JsonProperty("url")
    public String getUrl() {
        return url;
    }

    @JsonProperty("updated")
    public Long getUpdated() {
        return updated;
    }

    public UrlMonitoringEvent withOldStatus(Integer oldStatus) {
        this.oldStatus = oldStatus;
        return this;
    }

    public UrlMonitoringEvent withNewStatus(Integer newStatus) {
        this.newStatus = newStatus;
        return this;
    }

    public UrlMonitoringEvent withSources(Set<String> sources) {
        this.sources = sources;
        return this;
    }

    public UrlMonitoringEvent withUrl(String url) {
        this.url = url;
        return this;
    }

    public UrlMonitoringEvent withUpdated(Long updated) {
        this.updated = updated;
        return this;
    }

    public void setOldStatus(Integer oldStatus) {
        this.oldStatus = oldStatus;
    }

    public void setNewStatus(Integer newStatus) {
        this.newStatus = newStatus;
    }

    public void setSources(Set<String> sources) {
        this.sources = sources;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUpdated(Long updated) {
        this.updated = updated;
    }

    @Override
    public String toString() {
        return "UrlMonitoringEvent{" +
                "oldStatus=" + oldStatus +
                ", newStatus=" + newStatus +
                ", sources=" + sources +
                ", url='" + url + '\'' +
                ", updated=" + updated +
                '}';
    }
}
