package ru.yandex.direct.jobs.util.mail;

import org.apache.commons.validator.routines.EmailValidator;

import ru.yandex.direct.core.entity.user.model.User;

import static ru.yandex.direct.utils.CommonUtils.nvl;

public class EmailUtils {
    private static final EmailValidator emailValidator = EmailValidator.getInstance();

    /**
     * Возвращает email кампании или email пользователя (когда email кампании не валиден)
     * Возвращает null если оба не валидны
     *
     * @param user            пользователь
     * @param campaignEmail   email кампании
     */
    public static String getValidEmail(User user, String campaignEmail) {
        String email = campaignEmail.trim();
        if (emailValidator.isValid(email)) {
            return email;
        }
        email = nvl(user.getEmail(), "");
        return emailValidator.isValid(email) ? email : null;
    }
}
