package ru.yandex.direct.jobs.util.mail;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.dbutil.model.ClientId;

enum EventType {
    BAD_EMAIL,
    EMPTY_SLUG,
    MAIL_SENT,
    SENDER_ERROR
}

@JsonInclude(JsonInclude.Include.NON_NULL)
public class MailEvent<T> {
    @JsonProperty
    private final EventType reason;

    @JsonProperty
    private final T notification;

    @JsonProperty
    private final Long clientId;

    @JsonProperty
    private final Long uid;

    @JsonProperty
    private final String templateId;

    @JsonProperty
    private final String errorMessage;

    public MailEvent(EventType reason, ClientId clientId, User user,
                      T notification, String templateId,
                      String errorMessage) {
        this.reason = reason;
        this.clientId = clientId.asLong();
        this.uid = user.getUid();
        this.notification = notification;
        this.templateId = templateId;
        this.errorMessage = errorMessage;
    }
    public static <T> MailEvent<T> mailSent(T notification, ClientId clientId,
                                            User user, String templateId) {
        return new MailEvent<T>(EventType.MAIL_SENT, clientId, user, notification, templateId, null);
    }

    public static <T> MailEvent<T> badEmail(ClientId clientId, User user, String email) {
        return new MailEvent<T>(EventType.BAD_EMAIL, clientId, user, null, null, email);
    }

    public static <T> MailEvent<T> emptySlug(ClientId clientId, User user, String email) {
        return new MailEvent<T>(EventType.EMPTY_SLUG, clientId, user, null, null, email);
    }

    public static <T> MailEvent<T> senderError(T notification,
                                               ClientId clientId,
                                               User user, String templateId, String errorMessage) {
        return new <T>MailEvent<T>(EventType.SENDER_ERROR, clientId, user, notification, templateId, errorMessage);
    }
}
