package ru.yandex.direct.jobs.util.svn;

import com.trilead.ssh2.auth.AgentProxy;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.internal.io.svn.SVNSSHPrivateKeyUtil;

public class SvnSshAgentAuthenticationProvider implements ISVNAuthenticationProvider {
    private final String user;

    public SvnSshAgentAuthenticationProvider(String user) {
        this.user = user;
    }

    @Override
    public SVNAuthentication requestClientAuthentication(String kind, SVNURL url, String realm,
                                                         SVNErrorMessage errorMessage,
                                                         SVNAuthentication previousAuth,
                                                         boolean authMayBeStored) {
        AgentProxy agentProxy = SVNSSHPrivateKeyUtil.createOptionalSSHAgentProxy();
        return SVNSSHAuthentication.newInstance(
                user,
                agentProxy,
                url.getPort(),
                url,
                false
        );
    }

    @Override
    public int acceptServerAuthentication(SVNURL url, String realm, Object certificate, boolean resultMayBeStored) {
        return ISVNAuthenticationProvider.ACCEPTED;
    }
}
