package ru.yandex.direct.jobs.util.template;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import ru.yandex.direct.i18n.Language;

/**
 * Общий класс для считывания шаблонов
 * @param <T> тип оповещения, по которому получается шаблон
 */
public class MailTemplateResolver<T> {
    private final Map<Language, Map<T, String>> templateMapping;

    public MailTemplateResolver(Map<Language, Map<T, String>> templateMapping) {
        this.templateMapping = templateMapping;
    }

    public String resolveTemplateId(Language lang, T notification) {
        Set<Language> allTemplatesLanguages = getAllLanguagesWithTemplates();
        // Если в шаблонах нет нужного языка - отправляем письмо на русском
        Language userLang = allTemplatesLanguages.contains(lang) ? lang : Language.RU;

        Map<T, String> mappingsForLang = templateMapping.get(userLang);
        return mappingsForLang == null ? null : mappingsForLang.get(notification);
    }

    // возвращает все языки для которых есть шаблоны писем
    private Set<Language> getAllLanguagesWithTemplates() {
        return templateMapping.entrySet().stream()
                .filter(r -> !r.getValue().isEmpty())
                .map(r -> r.getKey())
                .collect(Collectors.toSet());
    }
}
