package ru.yandex.direct.jobs.util.yt;

import ru.yandex.direct.env.Environment;
import ru.yandex.direct.env.EnvironmentType;

public class YtEnvPath {
    private YtEnvPath() {
    }

    /**
     * Получить кусок пути, который нужно вставить между домашней директорием и именем результата,
     * для того, чтобы результаты в разных средах не пересекались
     */
    public static String relativePart() {
        EnvironmentType environmentType = Environment.getCached();
        if (environmentType.isProductionOrPrestable()) {
            return "./";
        } else {
            return String.format("%s_%s", System.getProperty("user.name"), environmentType.name().toLowerCase());
        }
    }
}
