package ru.yandex.direct.jobs.verifications;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

public class JobClusterState {
    @JsonProperty("last_check_timestamp")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    private Date lastCheckTimestamp;
    @JsonProperty("last_check_count_ok")
    private Integer lastCheckCountOk;
    @JsonProperty("last_check_count_failed")
    private Integer lastCheckCountFailed;

    public JobClusterState() {
    }

    public Date getLastCheckTimestamp() {
        return lastCheckTimestamp;
    }

    public JobClusterState withLastCheckTimestamp(Date lastCheckTimestamp) {
        this.lastCheckTimestamp = lastCheckTimestamp;
        return this;
    }

    public Integer getLastCheckCountOk() {
        return lastCheckCountOk;
    }

    public JobClusterState withLastCheckCountOk(Integer lastCheckCountOk) {
        this.lastCheckCountOk = lastCheckCountOk;
        return this;
    }

    public Integer getLastCheckCountFailed() {
        return lastCheckCountFailed;
    }

    public JobClusterState withLastCheckCountFailed(Integer lastCheckCountFailed) {
        this.lastCheckCountFailed = lastCheckCountFailed;
        return this;
    }
}
