package ru.yandex.direct.jobs.verifications;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;

public class JobState {
    @JsonProperty("cluster_states")
    private Map<String, JobClusterState> clusterStates = new HashMap<>();
    @JsonProperty("last_ticket")
    @Nullable
    private String lastTicket;
    @JsonProperty("last_ticket_created_timestamp")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX")
    @Nullable
    private Date lastTicketTimestamp;

    public JobState() {
    }

    public Map<String, JobClusterState> getClusterStates() {
        return clusterStates;
    }

    public JobState withClusterStates(Map<String, JobClusterState> clusterStates) {
        this.clusterStates = clusterStates;
        return this;
    }

    @Nullable
    public String getLastTicket() {
        return lastTicket;
    }

    public JobState withLastTicket(@Nullable String lastTicket) {
        this.lastTicket = lastTicket;
        return this;
    }

    @Nullable
    public Date getLastTicketTimestamp() {
        return lastTicketTimestamp;
    }

    public JobState withLastTicketTimestamp(@Nullable Date lastTicketTimestamp) {
        this.lastTicketTimestamp = lastTicketTimestamp;
        return this;
    }

    static JobState emptyJobState() {
        return new JobState();
    }
}
