package ru.yandex.direct.jobs.yt;

import java.time.Duration;

import javax.annotation.ParametersAreNonnullByDefault;

import static java.util.Objects.requireNonNull;

@ParametersAreNonnullByDefault
public class MysqlYtSyncBackupConfig {
    /**
     * Тип хранилища, который нужно использовать для статических таблиц
     */
    private final String primaryMedium;

    /**
     * TTL копии на кластере, с которого снимается бекап
     */
    private final Duration srcClusterCopyTtl;

    /**
     * TTL копии на кластере, куда будет привезён бекап
     */
    private final Duration dstClusterCopyTtl;

    public MysqlYtSyncBackupConfig(String primaryMedium, Duration srcClusterCopyTtl, Duration dstClusterCopyTtl) {
        this.primaryMedium = requireNonNull(primaryMedium);
        this.srcClusterCopyTtl = requireNonNull(srcClusterCopyTtl);
        this.dstClusterCopyTtl = requireNonNull(dstClusterCopyTtl);
    }

    public String getPrimaryMedium() {
        return primaryMedium;
    }

    public Duration getSrcClusterCopyTtl() {
        return srcClusterCopyTtl;
    }

    public Duration getDstClusterCopyTtl() {
        return dstClusterCopyTtl;
    }

    @Override
    public String toString() {
        return "MysqlYtSyncBackupConfig{" +
                "primaryMedium='" + primaryMedium + '\'' +
                ", srcClusterCopyTtl=" + srcClusterCopyTtl +
                ", dstClusterCopyTtl=" + dstClusterCopyTtl +
                '}';
    }
}
