package ru.yandex.direct.jobs.yt.audit;

import java.math.BigInteger;

/**
 * Диапазон айдишников от min включительно до max не включая.
 */
public class Chunk {
    public final BigInteger min;
    public final BigInteger max;
    public final long cnt;

    Chunk(BigInteger min, BigInteger max, long cnt) {
        this.min = min;
        this.max = max;
        this.cnt = cnt;
    }

    public BigInteger getMin() {
        return min;
    }

    public BigInteger getMax() {
        return max;
    }

    public long getCnt() {
        return cnt;
    }

    @Override
    public String toString() {
        return "Chunk{" +
                "min=" + min +
                ", max=" + max +
                ", cnt=" + cnt +
                '}';
    }
}
