package ru.yandex.direct.jobs.yt.audit;

import javax.annotation.ParametersAreNonnullByDefault;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.dbutil.wrapper.DatabaseWrapperProvider;
import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.scheduler.support.DirectJob;
import ru.yandex.direct.utils.JsonUtils;
import ru.yandex.direct.ytwrapper.client.YtProvider;

import static ru.yandex.direct.core.entity.ppcproperty.model.PpcPropertyEnum.YT_CHECKSUM_GENERATOR_PARAMS;

/**
 * Джоба, заполняющая таблицу yt_checksum
 * Пока вызывается вручную через внутренние инструменты и предназначена для тестирования
 * производительности сверок данных в зеркализаторе
 */
// Нужно добавить какое-то расписание чтобы джоба появилась во внутренних инструментах
@Hourglass(cronExpression = "0 0 11 1 1 ?")
@ParametersAreNonnullByDefault
public class ChunksGeneratorJob extends DirectJob {
    private static final Logger logger = LoggerFactory.getLogger(ChunksGeneratorJob.class);

    private final PpcPropertiesSupport ppcPropertiesSupport;
    private final DatabaseWrapperProvider databaseWrapperProvider;
    private final YtChecksumYtRepository ytRepository;

    @Autowired
    public ChunksGeneratorJob(PpcPropertiesSupport ppcPropertiesSupport,
                              DatabaseWrapperProvider databaseWrapperProvider,
                              YtProvider ytProvider) {
        this.ppcPropertiesSupport = ppcPropertiesSupport;
        this.databaseWrapperProvider = databaseWrapperProvider;
        this.ytRepository = new YtChecksumYtRepository(ytProvider);
    }

    @Override
    public void execute() {
        String propName = YT_CHECKSUM_GENERATOR_PARAMS.getName();
        String paramsStr = ppcPropertiesSupport.get(propName);
        if (paramsStr == null || paramsStr.isBlank()) {
            logger.info("No {} property, nothing to do", propName);
            return;
        }
        // Сбрасываем параметры запуска, т.к. они одноразовые
        /*if (ppcPropertiesSupport.cas(propName, paramsStr, "")) {
            logger.info("Loaded {}='{}', and then changed to empty string", propName, paramsStr);
        } else {
            logger.error("Conflict when working with {} property", propName);
            return;
        }*/
        TableCheckParams params = JsonUtils.fromJson(paramsStr, TableCheckParams.class);
        params.setIteration(-1);
        logger.info("Loaded params={}", params);

        TableChecker tableChecker = new TableChecker(databaseWrapperProvider, params, ytRepository);
        tableChecker.processTable();
    }
}
