package ru.yandex.direct.jobs.yt.audit;

import ru.yandex.direct.ytwrapper.model.YtCluster;

/**
 * Задача на проверку целостности данных для mysqlYtChecksum
 */
public class MysqlYtCheckTask {
    /**
     * Какая база является источником
     */
    private final String dbname;
    /**
     * Какой кластер YT является приёмником
     */
    private final YtCluster ytCluster;

    public MysqlYtCheckTask(String dbname, YtCluster ytCluster) {
        this.dbname = dbname;
        this.ytCluster = ytCluster;
    }

    public String getDbname() {
        return dbname;
    }

    public YtCluster getYtCluster() {
        return ytCluster;
    }

    @Override
    public String toString() {
        return "MysqlYtCheckTask{" +
                "dbname='" + dbname + '\'' +
                ", ytCluster=" + ytCluster +
                '}';
    }
}
