package ru.yandex.direct.jobs.yt.audit;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.Sets;

import ru.yandex.direct.scheduler.support.ParametersSource;
import ru.yandex.direct.ytwrapper.model.YtCluster;

@ParametersAreNonnullByDefault
public class MysqlYtCheckTaskParametersSource implements ParametersSource<MysqlYtCheckTask> {
    private final Set<String> dbNames;
    private final Set<YtCluster> ytClusters;

    public MysqlYtCheckTaskParametersSource(Set<String> dbNames, Set<YtCluster> ytClusters) {
        this.dbNames = dbNames;
        this.ytClusters = ytClusters;
    }

    @Override
    public List<MysqlYtCheckTask> getAllParamValues() {
        return Sets.cartesianProduct(dbNames, ytClusters).stream()
                .map(v -> new MysqlYtCheckTask((String) v.get(0), (YtCluster) v.get(1)))
                .collect(Collectors.toList());
    }

    @Override
    public String convertParamToString(MysqlYtCheckTask paramValue) {
        return String.format("%s/%s", paramValue.getDbname(), paramValue.getYtCluster().getName());
    }

    @Override
    public MysqlYtCheckTask convertStringToParam(String string) {
        String[] split = string.split("/");
        return new MysqlYtCheckTask(split[0], YtCluster.parse(split[1]));
    }
}
