package ru.yandex.direct.jobs.yt.audit;

import java.math.BigInteger;

import javax.annotation.Nullable;

public class NumberedChunk {
    private final int number;
    @Nullable
    private final Integer parent;
    private final Chunk chunk;

    public NumberedChunk(int number, @Nullable Integer parent, Chunk chunk) {
        this.chunk = chunk;
        this.number = number;
        this.parent = parent;
    }

    public int getNumber() {
        return number;
    }

    @Nullable
    public Integer getParent() {
        return parent;
    }

    public Chunk getChunk() {
        return chunk;
    }

    public BigInteger getMin() {
        return chunk.getMin();
    }

    public BigInteger getMax() {
        return chunk.getMax();
    }

    public boolean canBeSplitted() {
        if (getMin() == null || getMax() == null) {
            return false;
        }
        return getMax().subtract(getMin()).compareTo(BigInteger.TWO) >= 0;
    }

    @Override
    public String toString() {
        return "NumberedChunk{" +
                "number=" + number +
                ", parent=" + parent +
                ", chunk=" + chunk +
                '}';
    }
}
