package ru.yandex.direct.jobs.yt.audit;

import java.util.Collections;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.ytwrapper.model.YtCluster;

public class TableCheckParams {
    @JsonProperty("db")
    private String db = null;
    @JsonProperty("table")
    private String table = null;
    @JsonProperty("iteration")
    private int iteration = -1;
    @JsonProperty("min_chunk_num")
    private Integer minChunkNumber = null;
    @JsonProperty("max_chunk_num")
    private Integer maxChunkNumber = null;
    /**
     * Колонки, которые нужно игнорировать при верификации
     */
    @JsonProperty("exclude_columns")
    private List<String> excludeColumns = Collections.emptyList();
    @JsonProperty("batch_size")
    private int batchSize = 50;
    @JsonProperty("desiredChunkSize")
    private int desiredChunkSize = 50_000;
    /**
     * true  - после нахождения чанка с ошибками джоба не будет проверять оставшиеся чанки
     * false - будут проверены все чанки, даже если среди них будут чанки с несовпадающей чексуммой
     */
    @JsonProperty("stop_after_first_mismatch")
    private boolean stopAfterFirstMismatch = false;
    /**
     * Количество расхождений в строчках, после обнаружения которых поиск завершается
     */
    @JsonProperty("failed_rows_limit")
    private int failedRowsLimit = 10;
    /**
     * Максимально допустимое количество чанков, репликация которых завершилась ошибкой
     * (обычно такое происходит из-за таймаута при запросе в YT)
     * Пока лимит не превышен, такие чанки бьются пополам и отправляются снова
     * (в надежде на то, что на меньшем количестве ключей запрос успеет выполниться)
     * Когда лимит превышается, джоба завершает работу с ошибкой
     */
    @JsonProperty("failed_chunks_limit")
    private int failedChunksLimit = 20;
    @JsonProperty("delete_old")
    private boolean deleteOld = true;
    @JsonProperty("dest_yt_path")
    private String destYtPath;
    @JsonProperty("dest_yt_cluster")
    private YtCluster destYtCluster;

    public TableCheckParams() {
    }

    public String getDb() {
        return db;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public String getTable() {
        return table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public int getIteration() {
        return iteration;
    }

    public void setIteration(int iteration) {
        this.iteration = iteration;
    }

    public Integer getMinChunkNumber() {
        return minChunkNumber;
    }

    public void setMinChunkNumber(Integer minChunkNumber) {
        this.minChunkNumber = minChunkNumber;
    }

    public Integer getMaxChunkNumber() {
        return maxChunkNumber;
    }

    public void setMaxChunkNumber(Integer maxChunkNumber) {
        this.maxChunkNumber = maxChunkNumber;
    }

    public List<String> getExcludeColumns() {
        return excludeColumns;
    }

    public void setExcludeColumns(List<String> excludeColumns) {
        this.excludeColumns = excludeColumns;
    }

    public int getBatchSize() {
        return batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getDesiredChunkSize() {
        return desiredChunkSize;
    }

    public void setDesiredChunkSize(int desiredChunkSize) {
        this.desiredChunkSize = desiredChunkSize;
    }

    public boolean isStopAfterFirstMismatch() {
        return stopAfterFirstMismatch;
    }

    public void setStopAfterFirstMismatch(boolean stopAfterFirstMismatch) {
        this.stopAfterFirstMismatch = stopAfterFirstMismatch;
    }

    public int getFailedRowsLimit() {
        return failedRowsLimit;
    }

    public void setFailedRowsLimit(int failedRowsLimit) {
        this.failedRowsLimit = failedRowsLimit;
    }

    public int getFailedChunksLimit() {
        return failedChunksLimit;
    }

    public void setFailedChunksLimit(int failedChunksLimit) {
        this.failedChunksLimit = failedChunksLimit;
    }

    public boolean isDeleteOld() {
        return deleteOld;
    }

    public void setDeleteOld(boolean deleteOld) {
        this.deleteOld = deleteOld;
    }

    public String getDestYtPath() {
        return destYtPath;
    }

    public void setDestYtPath(String destYtPath) {
        this.destYtPath = destYtPath;
    }

    public YtCluster getDestYtCluster() {
        return destYtCluster;
    }

    public void setDestYtCluster(YtCluster destYtCluster) {
        this.destYtCluster = destYtCluster;
    }

    @Override
    public String toString() {
        return "TableCheckParams{" +
                "db='" + db + '\'' +
                ", table='" + table + '\'' +
                ", iteration=" + iteration +
                ", minChunkNumber=" + minChunkNumber +
                ", maxChunkNumber=" + maxChunkNumber +
                ", excludeColumns=" + excludeColumns +
                ", batchSize=" + batchSize +
                ", desiredChunkSize=" + desiredChunkSize +
                ", stopAfterFirstMismatch=" + stopAfterFirstMismatch +
                ", failedRowsLimit=" + failedRowsLimit +
                ", failedChunksLimit=" + failedChunksLimit +
                ", deleteOld=" + deleteOld +
                ", destYtPath='" + destYtPath + '\'' +
                ", destYtCluster=" + destYtCluster +
                '}';
    }
}
