package ru.yandex.direct.jobs.yt.audit;

import java.util.Collection;
import java.util.List;

import ru.yandex.direct.common.util.RepositoryUtils;
import ru.yandex.direct.core.entity.ytchecksum.YtChecksum;
import ru.yandex.direct.core.entity.ytchecksum.YtChecksumMethod;
import ru.yandex.direct.core.entity.ytchecksum.YtChecksumStatus;
import ru.yandex.direct.dbschema.ppc.tables.records.YtChecksumRecord;
import ru.yandex.direct.grid.core.util.yt.mapping.YtFieldMapper;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplier;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplierBuilder;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.model.YtDynamicOperator;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.yt.ytclient.wire.UnversionedRowset;

import static java.util.stream.Collectors.joining;
import static java.util.stream.Collectors.toList;
import static ru.yandex.direct.dbschema.ppc.Tables.YT_CHECKSUM;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

public class YtChecksumYtRepository {
    private final YtProvider ytProvider;

    private final YtFieldMapper<YtChecksum, YtChecksumRecord> ytMapper;

    public YtChecksumYtRepository(YtProvider ytProvider) {
        this.ytProvider = ytProvider;
        //
        JooqReaderWithSupplier<YtChecksum> reader = JooqReaderWithSupplierBuilder.builder(YtChecksum::new)
                .readProperty(YtChecksum.TBL, fromField(YT_CHECKSUM.TBL))
                .readProperty(YtChecksum.ITERATION, fromField(YT_CHECKSUM.ITERATION).by(RepositoryUtils::intFromLong))
                .readProperty(YtChecksum.CHUNK, fromField(YT_CHECKSUM.CHUNK).by(RepositoryUtils::intFromLong))
                .readProperty(YtChecksum.PARENT_CHUNK,
                        fromField(YT_CHECKSUM.PARENT_CHUNK).by(RepositoryUtils::intFromLong))
                .readProperty(YtChecksum.BOUNDARIES, fromField(YT_CHECKSUM.BOUNDARIES))
                .readProperty(YtChecksum.METHOD, fromField(YT_CHECKSUM.METHOD).by(YtChecksumMethod::fromSource))
                .readProperty(YtChecksum.THIS_CRC, fromField(YT_CHECKSUM.THIS_CRC))
                .readProperty(YtChecksum.THIS_CRC_CNT,
                        fromField(YT_CHECKSUM.THIS_CRC_CNT).by(RepositoryUtils::intFromLong))
                .readProperty(YtChecksum.THIS_STR, fromField(YT_CHECKSUM.THIS_STR))
                .readProperty(YtChecksum.THIS_NULLS_CNT, fromField(YT_CHECKSUM.THIS_NULLS_CNT))
                .readProperty(YtChecksum.YT_CRC, fromField(YT_CHECKSUM.YT_CRC))
                .readProperty(YtChecksum.YT_CRC_CNT, fromField(YT_CHECKSUM.YT_CRC_CNT).by(RepositoryUtils::intFromLong))
                .readProperty(YtChecksum.YT_STR, fromField(YT_CHECKSUM.YT_STR))
                .readProperty(YtChecksum.YT_NULLS_CNT, fromField(YT_CHECKSUM.YT_NULLS_CNT))
                .readProperty(YtChecksum.COLUMNS_USED, fromField(YT_CHECKSUM.COLUMNS_USED))
                .readProperty(YtChecksum.STATUS, fromField(YT_CHECKSUM.STATUS).by(YtChecksumStatus::fromSource))
                .readProperty(YtChecksum.TS, fromField(YT_CHECKSUM.TS))
                .build();
        this.ytMapper = new YtFieldMapper<>(reader, YT_CHECKSUM);
    }

    public List<YtChecksum> getReplicated(Collection<NumberedChunk> chunks,
                                          TableCheckParams params) {
        YPath tablePath = YPath.simple(params.getDestYtPath()).child("straight").child("yt_checksum");
        YtDynamicOperator dynamicOperator = ytProvider.getDynamicOperator(params.getDestYtCluster());
        String sql = String.format("" +
                        " tbl," +
                        " iteration," +
                        " chunk," +
                        " parent_chunk," +
                        " boundaries," +
                        " method," +
                        " this_crc," +
                        " this_crc_cnt," +
                        " this_str," +
                        " this_nulls_cnt," +
                        " yt_crc," +
                        " yt_crc_cnt," +
                        " yt_str," +
                        " yt_nulls_cnt," +
                        " columns_used," +
                        " status," +
                        " ts" +
                        " from [%s]" +
                        " WHERE tbl = '%s' AND iteration = %d AND chunk in (%s)",
                tablePath,
                params.getTable() + "/" + params.getDestYtCluster().getName(),
                params.getIteration(),
                chunks.stream().map(NumberedChunk::getNumber).map(Object::toString).collect(joining(",")));
        UnversionedRowset unversionedRowset = dynamicOperator.selectRows(sql);
        return unversionedRowset.getYTreeRows().stream()
                .map(ytMapper::fromNode)
                .collect(toList());
    }
}
