PRAGMA yt.Pool = ?;

$date = ?;
$result_balance_log = ?;
$balance_table_prefix = ?;
$currency_rates_table_path = ?;
$log_table = $balance_table_prefix || $date;

/*-------- Конвертер в рубли по последнему доступному курсу ---------*/
$ynd_fixed_rate = 30;
$rates_list =
    SELECT AGGREGATE_LIST(AsTuple(currency, rate))
    FROM (
        SELECT currency
            , UnWrap(MAX_BY(CAST(rate AS Double), `date`)) AS rate
        FROM $currency_rates_table_path
        GROUP BY UnWrap(currency) AS currency
    );

$converter_to_rub_from_rates = ($rates) -> {
    $dict = ToDict($rates);
    RETURN ($sum, $source_currency) -> {
        RETURN CASE
            WHEN $source_currency = 'RUB' THEN $sum
            WHEN $source_currency = 'YND_FIXED' THEN $sum * $ynd_fixed_rate
            WHEN NOT DictContains($dict, $source_currency) THEN NULL
            ELSE $sum * $dict[$source_currency]
            END;
    };
};
$cur_convert = $converter_to_rub_from_rates($rates_list);
/* ------------------------------------------------------------------------- */

INSERT INTO $result_balance_log WITH TRUNCATE
SELECT tid, ClientID, cid, type,
       currency, sum, sum_delta,
       $cur_convert(sum, currency) as sum_rub,
       $cur_convert(sum_delta, currency) as sum_delta_rub
FROM (
    SELECT tid, ClientID, cid, some(type) as type,
           some(currency) as currency, some(sum) as sum, some(sum_delta) as sum_delta
    FROM $log_table
    GROUP BY tid, ClientID, cid
)
order by ClientID, cid;;
