PRAGMA yt.Pool = ?;

$date = ?;
$result_bs_stat = ?;
$grid_stat_table = ?;
$shard_inc_cid_table = ?;
$mysql_sync_path = ?;

$datetime_parse_tz = DateTime::Parse("%Y-%m-%dT%H:%M:%S,%Z");
$unix_time = DateTime::ToSeconds(DateTime::MakeDatetime($datetime_parse_tz($date || "T00:00:00,Europe/Moscow")));

$grouped_stat_log_result = (
    SELECT c.ClientID as ClientID,
        s.ExportID as cid,
        sum(s.Shows) as shows,
        sum(s.Clicks) as clicks,
        sum(s.Cost * 30.0 / 1000000) as cost_rub
    FROM $grid_stat_table as s
    JOIN $shard_inc_cid_table as c
        ON c.cid = s.ExportID
    WHERE s.UpdateTime = $unix_time
    GROUP BY c.ClientID, s.ExportID
);

$grouped_stat_log_by_camp_type_result = (
    SELECT c.ClientID as ClientID,
        s.ExportID as cid,
        camp.type as type,
        sum(s.Shows) as shows,
        sum(s.Clicks) as clicks,
        sum(s.Cost * 30.0 / 1000000) as cost_rub
    FROM $grid_stat_table as s
    JOIN $shard_inc_cid_table as c
        ON c.cid = s.ExportID
    JOIN LIKE($mysql_sync_path, `ppc:%`, `straight/campaigns`) as camp
        ON camp.cid = c.cid
    WHERE s.UpdateTime = $unix_time
        AND camp.type in ('dynamic', 'performance')
    GROUP BY c.ClientID, s.ExportID, camp.type
);

INSERT INTO $result_bs_stat WITH TRUNCATE
SELECT * FROM (
    SELECT * FROM $grouped_stat_log_result
    UNION ALL SELECT * FROM $grouped_stat_log_by_camp_type_result)
ORDER BY ClientID, cid;
