PRAGMA yt.Pool = ?;

--в этом скрипте считаем исполнение нужных нам событий у клиента в i-ый раз

$date_time_parser = DateTime::Parse("%Y-%m-%d %H:%M:%S");
$date_parser = DateTime::Parse("%Y-%m-%d");

$date = ?;
$parsed_date = DateTime::MakeDate($date_parser($date));

$result_path = ?;

$event_path_prefix = ?;

$event_table_name = ?;

$number_of_days_to_process = ?;

$events_pathes = (
    SELECT AGGREGATE_LIST($event_path_prefix || CAST (date_list AS String) || "/" || $event_table_name)
    FROM (
             SELECT ListMap(
                            ListFromRange(0, $number_of_days_to_process),
                            ($shift) -> {
                                RETURN $parsed_date - DateTime::IntervalFromDays(CAST ($shift AS Int16))
                            }
            ) AS date_list)
    FLATTEN LIST BY date_list
);

$client_created_during_processing_time = (
    SELECT ClientID,
        MIN(first_event_time) as event_time
    FROM EACH($events_pathes)
    WHERE event_type in ('client_create')
    GROUP BY ClientID
);

$events_of_recently_created_clients_with_order_number = (
    SELECT ev.ClientID AS ClientID,
        ev.event_type AS event_type,
        ROW_NUMBER() OVER w1 AS order_number,
        ev.first_event_time AS first_event_time
    FROM EACH($events_pathes) AS ev
    RIGHT JOIN $client_created_during_processing_time AS cev
    ON ev.ClientID == cev.ClientID
    WHERE ev.event_type IN ('camp_create', 'shows_update', 'camp_moderate_ready')
        OR ev.event_type LIKE '%_camp_create'
        OR (ev.event_type == 'sum_change' AND ev.money_sum_rub > 0)
    WINDOW
        w1 AS (PARTITION BY ev.ClientID, ev.event_type ORDER BY ev.first_event_time)
);

$events_of_recently_created_clients_with_order_number_and_interval = (
    SELECT ev.ClientID AS ClientID,
           event_type AS event_type,
           ev.order_number AS order_number,
           DateTime::MakeDatetime($date_time_parser(ev.first_event_time)) - DateTime::MakeDatetime($date_time_parser(cev.event_time)) AS time_interval_between_client_create_and_event,
           ev.first_event_time AS event_time
    FROM $events_of_recently_created_clients_with_order_number AS ev
    JOIN $client_created_during_processing_time AS cev
    ON ev.ClientID == cev.ClientID
);

$start_of_that_day = DateTime::MakeDatetime(DateTime::StartOfDay($date_parser($date)));
$end_of_that_day = DateTime::MakeDatetime(DateTime::Update($date_parser($date), 23 AS Hour, 59 AS Minute, 59 AS Second));

INSERT INTO $result_path WITH TRUNCATE
SELECT * FROM
    (SELECT ClientID,
        DateTime::ToSeconds(time_interval_between_client_create_and_event) as seconds_from_client_create,
        CASE
            WHEN event_type = 'camp_create' THEN
                CASE order_number
                    WHEN 1 THEN 'first_camp_create'
                    WHEN 2 THEN 'second_camp_create'
                    ELSE NULL
                END
            WHEN String::EndsWith(event_type, '_camp_create') THEN
                CASE order_number
                    WHEN 1 THEN event_type || '_first'
                    ELSE NULL
                END
            WHEN event_type = 'shows_update' THEN
                CASE order_number
                    WHEN 1 THEN 'first_date_with_shows'
                    ELSE NULL
                END
            WHEN event_type = 'camp_moderate_ready' THEN
                CASE order_number
                    WHEN 1 THEN 'first_camp_moderate_ready'
                    ELSE NULL
                END
            WHEN event_type = 'sum_change' THEN
                CASE order_number
                    --возможно хочется first_day_with_payments
                    WHEN 1 THEN 'first_payment'
                    WHEN 2 THEN 'second_payment'
                    ELSE NULL
                END
            ELSE NULL
        END AS event_type
     FROM $events_of_recently_created_clients_with_order_number_and_interval
     WHERE DateTime::MakeDatetime($date_time_parser(event_time)) BETWEEN $start_of_that_day and $end_of_that_day)
WHERE event_type IS NOT NULL
ORDER BY ClientID, event_type;
