PRAGMA yt.Pool = ?;

PRAGMA yson.AutoConvert='true';
PRAGMA yson.Strict='false';

$date = ?;
$result_uaas_data = ?;
$uaas_log_prefix = ?;
$uaas_interval_days = 7;

$uaas_start = DateTime::Format('%Y-%m-%d')(
    DateTime::FromSeconds(cast(DateTime::ToSeconds(CAST($date AS Date)) - ($uaas_interval_days-1) * 86400 as uint32))
    );

INSERT INTO $result_uaas_data WITH TRUNCATE
        SELECT ClientID, bucket, min(if(substring(log_time,0,10) == $date, log_time)) as min_log_time_today, min(log_time) as min_log_time
          FROM (
            SELECT client_id as ClientID
                 , log_time
                 , ListFilter(
                               String::SplitToList(exp_boxes, ';')
                               , ($s) -> {RETURN $s != ''})
                   as buckets
              FROM RANGE($uaas_log_prefix, $uaas_start, $date)
            )
        FLATTEN BY buckets as bucket
        GROUP BY ClientID, bucket;
