$src_dir = ?;
$day = ?;
$dst_dir = ?;

$src_table = $src_dir || "/" || $day;
$insert_suggest_table = $dst_dir || "/suggest/" || $day;
$insert_apply_table = $dst_dir || "/apply/" || $day;

$options = Yson::Options(true as Strict, true as AutoConvert);
$MESSAGE_PREFIX = "Apply images generation: ";

$WARN_TO_RESULT = {
    "GenerationDefectIds.DOMAIN_DISABLED": "DOMAIN_DISABLED",
    "GenerationDefectIds.EMPTY_IMAGE_SEARCH_API_RESPONSE": "EMPTY_RESULT",
    "GenerationDefectIds.CAMPAIGN_WITHOUT_HREF": "EMPTY_URL",
    "GenerationDefectIds.AD_GROUP_WITHOUT_KEYWORDS": "EMPTY_TEXT",
    "GenerationDefectIds.IMAGE_SEARCH_API_ERROR": "ERRORS",
    "GenerationDefectIds.RICH_CONTENT_API_ERROR": "ERRORS"
};
$WARN_ORDER = {
    "GenerationDefectIds.CAMPAIGN_WITHOUT_HREF",
    "GenerationDefectIds.AD_GROUP_WITHOUT_KEYWORDS",
    "GenerationDefectIds.RICH_CONTENT_API_ERROR",
    "GenerationDefectIds.IMAGE_SEARCH_API_ERROR",
    "GenerationDefectIds.EMPTY_IMAGE_SEARCH_API_RESPONSE",
    "GenerationDefectIds.DOMAIN_DISABLED"
};
$RESULT_ORDER = {
    "OK": 1,
    "EMPTY_RESULT": 2,
    "EMPTY_URL": 3,
    "EMPTY_TEXT": 4,
    "ERRORS": 5,
    "DOMAIN_DISABLED": 6,
    "UNKNOWN": 7
};

-- START SUGGEST FUNCTIONS

$removeUrlProtocol = ($url) -> {
    $url = String::ToLower($url);
    $url = if(
        String::StartsWith($url, "https://"),
        Substring($url, Length("https://")),
        if(
            String::StartsWith($url, "http://"),
            Substring($url, Length("http://")),
            $url
        )
    );
    return $url;
};

$removeUrlsProtocol = ($urls) -> {
    RETURN ListMap($urls, ($u) -> { RETURN $removeUrlProtocol($u); });
};

$warnings_to_result = ($warnings, $suggests) -> {
    $knownWarnings = ListSort(ListFilter($warnings, ($w) -> {RETURN DictContains($WARN_TO_RESULT, $w);}), ($r) -> { RETURN $WARN_ORDER[$r]; });
    RETURN
        if(ListLength($suggests) > 0, "OK",
        if(ListLength($knownWarnings) == 0, "UNKNOWN",
        $WARN_TO_RESULT[$knownWarnings[0]]
        ));
};

$handle_suggests = ($suggests) -> {
    $suggestsByTitle = ListFilter($suggests, ($s) -> { RETURN $s.sourceInfo.mainTexts > 0 and $s.sourceInfo.additionalTexts = 0 });
    $suggestsByKeywords = ListFilter($suggests, ($s) -> { RETURN $s.sourceInfo.mainTexts = 0 and $s.sourceInfo.additionalTexts > 0 });
    $suggestsByBoth = ListFilter($suggests, ($s) -> { RETURN $s.sourceInfo.mainTexts > 0 and $s.sourceInfo.additionalTexts > 0 });
    $suggestsFromRCAByUrl = ListFilter($suggests, ($s) -> { RETURN $s.sourceInfo.mainTexts = 0 and $s.sourceInfo.additionalTexts = 0 and $s.sourceInfo.richContentByUrl > 0 });
    $suggestsFromRCAByDomain = ListFilter($suggests, ($s) -> { RETURN $s.sourceInfo.mainTexts = 0 and $s.sourceInfo.additionalTexts = 0 and $s.sourceInfo.richContentByUrl = 0 });
    RETURN AsStruct(
        ListMap($suggestsByTitle, ($s) -> { RETURN $removeUrlProtocol($s.url); }) as byTitle,
        ListMap($suggestsByKeywords, ($s) -> { RETURN $removeUrlProtocol($s.url); }) as byKeywords,
        ListMap($suggestsByBoth, ($s) -> { RETURN $removeUrlProtocol($s.url); }) as byBoth,
        ListMap($suggestsFromRCAByUrl, ($s) -> { RETURN $removeUrlProtocol($s.url); }) as rcaByUrl,
        ListMap($suggestsFromRCAByDomain, ($s) -> { RETURN $removeUrlProtocol($s.url); }) as rcaByDomain
    );
};

$merge_suggests = ($suggests) -> {
    $byTitle = ListUniq(ListFlatten(ListExtract($suggests, "byTitle")));
    $byKeywords = ListUniq(ListFlatten(ListExtract($suggests, "byKeywords")));
    $byBoth = ListFlatten(ListExtract($suggests, "byBoth"));
    $rcaByUrl = ListUniq(ListFlatten(ListExtract($suggests, "rcaByUrl")));
    $rcaByDomain = ListUniq(ListFlatten(ListExtract($suggests, "rcaByDomain")));

    $byBoth = ListUniq(ListExtend($byBoth, ListFilter($byTitle, ($u) -> { RETURN ListHas($byKeywords, $u); })));
    $byTitle = ListFilter($byTitle, ($u) -> { RETURN not ListHas($byBoth, $u); });
    $byKeywords = ListFilter($byKeywords, ($u) -> { RETURN not ListHas($byBoth, $u); });

    $temp = ListExtend($byBoth, $byTitle, $byKeywords);
    $rcaByUrl = ListFilter($rcaByUrl, ($u) -> { RETURN not ListHas($temp, $u); });
    $temp = ListExtend($temp, $rcaByUrl);
    $rcaByDomain = ListFilter($rcaByDomain, ($u) -> { RETURN not ListHas($temp, $u); });
    RETURN AsStruct(
        $byTitle as byTitle,
        $byKeywords as byKeywords,
        $byBoth as byBoth,
        $rcaByUrl as rcaByUrl,
        $rcaByDomain as rcaByDomain
    );
};

$calc_summary_result = ($results) -> {
    $results = ListSort($results, ($r) -> { RETURN $RESULT_ORDER[$r]; });
    RETURN if(ListLength($results) == 0, "NOT_USED", $results[0]);
};

$intersection = ($apply, $suggest) -> {
    RETURN ListFilter($apply, ($a) -> { RETURN ListHas($suggest, $a); });
};

-- FINISH SUGGEST FUNCTIONS

-- START SELECTS

$data = (
    select
        log_time as log_time,
        trace_id as log_req_id,
        Yson::ParseJson(Substring(message, length($MESSAGE_PREFIX))) as data
    from $src_table
    where String::StartsWith(message, $MESSAGE_PREFIX)
        AND method = 'ad_generation.ad_generation.save_results'
        AND service = 'direct.web'
        AND class_name = 'ru.yandex.direct.web.entity.adgeneration.controller.AdGenerationController'
        AND CAST(Substring(message, length($MESSAGE_PREFIX)) as Json) is not null
);

$maxSuggestNum = (select max(Yson::GetLength(data.generationResponses)) from $data where not Yson::IsEntity(data.generationResponses));
$maxSuggestNum = nvl($maxSuggestNum, 1);
$index = (select row_number() over w - 1 as index from $src_table WINDOW w AS () limit $maxSuggestNum);

$suggests = (
    SELECT
        d.log_req_id as log_req_id,
        d.log_time as log_time,
        d.log_time as apply_time,
        Yson::ConvertToUint64(d.data.bannerId, $options) as banner_id,
        Yson::ConvertToUint64(d.data.saveReqId, $options) as apply_req_id,
        Yson::ConvertTo(d.data.savedImageUrls, List<String>, $options) as apply,
        Yson::ConvertTo(d.data.clickedImageUrls, List<String>, $options) as clicked,
        Yson::ConvertTo(d.data.showedImageUrls, List<String>, $options) as showed,
        Yson::ConvertTo(d.data.generationResponses[i.index].suggests, List<Struct<
            url: String,
            height: Uint32,
            width: Uint32,
            sourceInfo: Struct<
                additionalTexts: Uint32,
                mainTexts: Uint32,
                richContentByUrl: Uint32,
                richContentByDomain: Uint32
            >
        >>) as suggests,
        Yson::ConvertToUint64(d.data.generationResponses[i.index].additionalInfo.adGroupId, $options) as group_id,
        Yson::ConvertToUint64(d.data.generationResponses[i.index].additionalInfo.campaignId, $options) as cid,
        Yson::ConvertToUint64(d.data.generationResponses[i.index].reqId, $options) as suggest_req_id,
        Yson::ConvertToString(d.data.generationResponses[i.index].additionalInfo.text, $options) as title,
        Yson::ConvertToString(d.data.generationResponses[i.index].additionalInfo.url, $options) as url,
        Yson::ConvertTo(d.data.generationResponses[i.index].additionalInfo.warnings, List<String>) as warnings,
        if(
            Yson::Contains(d.data.generationResponses[i.index].additionalInfo, "keywords"),
            Yson::ConvertTo(d.data.generationResponses[i.index].additionalInfo.keywords, List<String>),
            AsList()
        ) as keywords
    from $data as d
    cross join $index as i
    where not Yson::IsEntity(data.generationResponses)
    and Yson::GetLength(d.data.generationResponses) > i.index
);

$suggests = (
    SELECT
        log_req_id, log_time, apply_req_id, apply_time, suggest_req_id,
        banner_id, group_id, cid, title, url,
        warnings, keywords,
        $removeUrlsProtocol(apply) as apply,
        $removeUrlsProtocol(clicked) as clicked,
        $removeUrlsProtocol(showed) as showed,
        $warnings_to_result(warnings, suggests) as result,
        $handle_suggests(suggests) as suggests
    from $suggests
);

$apply = (
    SELECT
        some(log_req_id) as log_req_id,
        some(log_time) as log_time,
        apply_req_id,
        some(apply_time) as apply_time,
        count(distinct suggest_req_id) as suggest_req_num,
        banner_id,
        some(group_id) as group_id,
        some(cid) as cid,
        AGGREGATE_LIST_DISTINCT(title) as titles,
        AGGREGATE_LIST_DISTINCT(url) as urls,
        ListUniq(ListFlatten(AGGREGATE_LIST(warnings))) as warnings,
        $calc_summary_result(AGGREGATE_LIST(result)) as result,
        ListUniq(ListFlatten(AGGREGATE_LIST(keywords))) as keywords,
        some(apply) as apply,
        some(clicked) as clicked,
        some(showed) as showed,
        $merge_suggests(AGGREGATE_LIST(suggests)) as suggests
    from $suggests
    group by banner_id, apply_req_id
);

$apply = (
    SELECT
        log_req_id, log_time, apply_req_id, apply_time,
        suggest_req_num,
        banner_id, group_id, cid,
        titles, urls,
        warnings, result, keywords, apply, clicked, showed,
        suggests.byTitle as suggestByTitle,
        suggests.byKeywords as suggestByKeywords,
        suggests.byBoth as suggestByBoth,
        suggests.rcaByUrl as suggestRCAByUrl,
        suggests.rcaByDomain as suggestRCAByDomain,
        $intersection(showed, suggests.byTitle) as showedByTitle,
        $intersection(showed, suggests.byKeywords) as showedByKeywords,
        $intersection(showed, suggests.byBoth) as showedByBoth,
        $intersection(showed, suggests.rcaByUrl) as showedRCAByUrl,
        $intersection(showed, suggests.rcaByDomain) as showedRCAByDomain,
        $intersection(clicked, suggests.byTitle) as clickedByTitle,
        $intersection(clicked, suggests.byKeywords) as clickedByKeywords,
        $intersection(clicked, suggests.byBoth) as clickedByBoth,
        $intersection(clicked, suggests.rcaByUrl) as clickedRCAByUrl,
        $intersection(clicked, suggests.rcaByDomain) as clickedRCAByDomain,
        $intersection(apply, suggests.byTitle) as applyByTitle,
        $intersection(apply, suggests.byKeywords) as applyByKeywords,
        $intersection(apply, suggests.byBoth) as applyByBoth,
        $intersection(apply, suggests.rcaByUrl) as applyRCAByUrl,
        $intersection(apply, suggests.rcaByDomain) as applyRCAByDomain
    from $apply
);

$insert_suggests = (
    select
        log_req_id, log_time, apply_req_id, apply_time, suggest_req_id,
        banner_id, group_id, cid, title, url, result,
        ListLength(warnings) as warnings_num, warnings,
        ListLength(keywords) as keywords_num, keywords,
        -- ListLength(apply) as apply_num, apply,
        -- ListLength(clicked) as clicked_num, clicked,
        -- ListLength(showed) as showed_num, showed,
        ListLength(suggests.byTitle) as suggestByTitle_num, suggests.byTitle as suggestByTitle,
        ListLength(suggests.byKeywords) as suggestByKeywords_num, suggests.byKeywords as suggestByKeywords,
        ListLength(suggests.byBoth) as suggestByBoth_num, suggests.byBoth as suggestByBoth,
        ListLength(suggests.rcaByUrl) as suggestRCAByUrl_num, suggests.rcaByUrl as suggestRCAByUrl,
        ListLength(suggests.rcaByDomain) as suggestRCAByDomain_num, suggests.rcaByDomain as suggestRCAByDomain
    from $suggests
);

$insert_apply = (
    select
        log_req_id, log_time, apply_req_id, apply_time,
        suggest_req_num,
        banner_id, group_id, cid, result,
        ListLength(titles) as titles_num, titles,
        ListLength(urls) as urls_num, urls,
        ListLength(warnings) as warnings_num, warnings,
        ListLength(keywords) as keywords_num, keywords,
        -- ListLength(apply) as apply_num, apply,
        ListLength(applyByTitle) as applyByTitle_num, applyByTitle,
        ListLength(applyByKeywords) as applyByKeywords_num, applyByKeywords,
        ListLength(applyByBoth) as applyByBoth_num, applyByBoth,
        ListLength(applyRCAByUrl) as applyRCAByUrl_num, applyRCAByUrl,
        ListLength(applyRCAByDomain) as applyRCAByDomain_num, applyRCAByDomain,
        -- ListLength(clicked) as clicked_num, clicked,
        ListLength(clickedByTitle) as clickedByTitle_num, clickedByTitle,
        ListLength(clickedByKeywords) as clickedByKeywords_num, clickedByKeywords,
        ListLength(clickedByBoth) as clickedByBoth_num, clickedByBoth,
        ListLength(clickedRCAByUrl) as clickedRCAByUrl_num, clickedRCAByUrl,
        ListLength(clickedRCAByDomain) as clickedRCAByDomain_num, clickedRCAByDomain,
        -- ListLength(showed) as showed_num, showed,
        ListLength(showedByTitle) as showedByTitle_num, showedByTitle,
        ListLength(showedByKeywords) as showedByKeywords_num, showedByKeywords,
        ListLength(showedByBoth) as showedByBoth_num, showedByBoth,
        ListLength(showedRCAByUrl) as showedRCAByUrl_num, showedRCAByUrl,
        ListLength(showedRCAByDomain) as showedRCAByDomain_num, showedRCAByDomain,
        -- ListLength(suggest) as suggest_num, suggest,
        ListLength(suggestByTitle) as suggestByTitle_num, suggestByTitle,
        ListLength(suggestByKeywords) as suggestByKeywords_num, suggestByKeywords,
        ListLength(suggestByBoth) as suggestByBoth_num, suggestByBoth,
        ListLength(suggestRCAByUrl) as suggestRCAByUrl_num, suggestRCAByUrl,
        ListLength(suggestRCAByDomain) as suggestRCAByDomain_num, suggestRCAByDomain,
    from $apply
);

-- select * from $suggests order by log_req_id;

-- select * from $apply order by log_req_id;

insert into $insert_suggest_table WITH TRUNCATE
select * from $insert_suggests order by log_req_id;

insert into $insert_apply_table WITH TRUNCATE
select * from $insert_apply order by log_req_id;

select
result, count(*) as cnt
from $apply
group by result as result;
