$dir = ?;
$day = ?;
$output = ?;

$src_table = $dir || "/" || $day;
$insert_detailed_table = $output || "/byDays/" || $day;
$insert_summary_table = $output || "/summary";
$parse = DateTime::Parse("%Y-%m-%d");
$format = DateTime::Format("%Y-%m-%d");

$options = Yson::Options(true as Strict, true as AutoConvert);
$MESSAGE_PREFIX = "Apply UC images generation: ";

$data = (
    select
        log_time as log_time,
        trace_id as log_req_id,
        Yson::ParseJson(Substring(message, length($MESSAGE_PREFIX))) as data
    from $src_table
    where String::StartsWith(message, $MESSAGE_PREFIX)
        AND method = 'ad_generation.ad_generation.save_results'
        AND service = 'direct.web'
        AND class_name = 'ru.yandex.direct.web.entity.adgeneration.controller.AdGenerationController'
        AND CAST(Substring(message, length($MESSAGE_PREFIX)) as Json) is not null
);

$data = (
    select
        log_time,
        log_req_id,
        Yson::ConvertTo(data, Struct<
            savedImageUrls: List<String>,
            generationResponses: List<Struct<
                reqId: Uint64,
                additionalInfo: Struct<
                    warnings: List<String>
                >,
                suggests: List<Struct<
                    url: String,
                    height: Uint32,
                    width: Uint32,
                    sourceInfo: Struct<
                        additionalTexts: Uint32,
                        mainTexts: Uint32,
                        richContentByUrl: Uint32,
                        richContentByDomain: Uint32
                    >
                >>
            >>
        >, $options) as data
    from $data
);

$formatUrl = ($url) -> {
    $url = String::AsciiToLower($url);
    $url = if(String::StartsWith($url, "http://"), Substring($url, Length("http://")), $url);
    $url = if(String::StartsWith($url, "https://"), Substring($url, Length("https://")), $url);
    $url = if(
        String::Contains("/" || '?' || "&#", nvl(Substring($url, cast(Length($url) - 1 as uint32)), "none")),
        Substring($url, 0, cast(Length($url) - 1 as uint32)),
        $url);
    $url = if(
        String::EndsWith($url, "&n=13") or String::EndsWith($url, '?' || "n=13"),
        Substring($url, 0, Length($url)-Length("&n=13")),
        $url);
    return $url;
};

$isSameUrls = ($left, $right) -> {
    RETURN $formatUrl($left) == $formatUrl($right);
};

$handle_suggest = ($data) -> {
    $saved = if(ListLength($data.savedImageUrls)=0, null, $data.savedImageUrls[0]);
    $suggest = if(
        ListLength($data.generationResponses) = 0,
        null,
        ListReverse($data.generationResponses)[0]
    );
    $suggest = if($suggest is null or $suggest.reqId=0, null, $suggest);
    $type = if($suggest is null, "NONE",
        if(ListLength($suggest.suggests)=0, "EMPTY",
        if(ListHas($suggest.additionalInfo.warnings, "GenerationDefectIds.EMPTY_IMAGE_SEARCH_API_RESPONSE"), "RCA",
        "SEARCH"
    )));
    $num = ListLength(ListTake($suggest.suggests, 20));
    $save = if(
        $saved is null, "NONE",
        if(ListLength(ListFilter($suggest.suggests, ($s) -> {RETURN $isSameUrls($s.url, $saved)}))>0, "SUGGEST",
            "OTHER"));
    RETURN AsStruct(
        $type as type,
        $save as save,
        $num as num
    );
};

$detailed = (
    select
        log_time,
        log_req_id,
        results.type as type,
        results.save as save,
        results.num as num
    from (
        select
            log_time,
            log_req_id,
            $handle_suggest(data) as results
        from $data
    )
);

insert into $insert_detailed_table with truncate
select
    log_time, log_req_id,
    type, save, num
from $detailed
order by log_time;

$numStat = (
    select
        ListConcat(AGGREGATE_LIST("suggest_num_" || cast(num as String) || "=" || cast(cnt as String)), ";")
    from (
        select
            num, count(*) as cnt
        from $detailed
        group by num
    )
);

$summary = (
    select
        $day as day,
        count(*) as cases,
        count_if(type != "NONE") as requests,
        count_if(type not in ("NONE", "EMPTY")) as suggests,
        ";" || ListConcat(AsList(
            "SUCCESS=" || cast(COUNT_IF(save="SUGGEST") as String),
            "SEARCH=" || cast(COUNT_IF(type="SEARCH") as String),
            "SUCCESS_SEARCH=" || cast(COUNT_IF(save="SUGGEST" and type="SEARCH") as String),
            "RCA=" || cast(COUNT_IF(type="RCA") as String),
            "SUCCESS_RCA=" || cast(COUNT_IF(save="SUGGEST" and type="RCA") as String),
            $numStat
        ), ";") || ";" as additional
    from $detailed
);

select * from $summary;

$summary = (
    select * from $summary
    where day not in (select day from $insert_summary_table where day = $day)
);

insert into $insert_summary_table
select day, cases, requests, suggests, additional from $summary;
