$dir = ?;
$day = ?;
$output = ?;

$src_table = $dir || "/" || $day;
$insert_detailed_table = $output || "/byDays/" || $day;
$insert_summary_table = $output || "/summary";
$parse = DateTime::Parse("%Y-%m-%d");
$format = DateTime::Format("%Y-%m-%d");

$options = Yson::Options(true as Strict, true as AutoConvert);
$MESSAGE_PREFIX = "Apply UC sitelinks generation: ";
$FIXED_MESSAGE_PREFIX = "Apply sitelinks generation: ";

$data = (
    select
        log_time as log_time,
        trace_id as log_req_id,
        Yson::ParseJson(Substring(message, length($MESSAGE_PREFIX))) as data
    from $src_table
    where String::StartsWith(message, $MESSAGE_PREFIX)
        AND method = 'ad_generation.ad_generation.save_results'
        AND service = 'direct.web'
        AND class_name = 'ru.yandex.direct.web.entity.adgeneration.controller.AdGenerationController'
        AND CAST(Substring(message, length($MESSAGE_PREFIX)) as Json) is not null
);

$data = (
    select
        log_time,
        log_req_id,
        Yson::ConvertTo(data, Struct<
            campaignId: uint64,
            savedSitelinks: List<Struct<
                url: String,
                title: String
            >>,
            generationResponses: List<Struct<
                reqId: Uint64,
                additionalInfo: Struct<
                    requestUrl: String,
                    foundUrl: String,
                    warnings: List<String>
                >,
                suggests: List<Struct<
                    url: String,
                    title: String
                >>
            >>
        >, $options) as data
    from $data
);

$data = (
    select
        log_time,
        log_req_id,
        data.campaignId as cid,
        data.savedSitelinks as saved,
        if (ListLength(data.generationResponses) = 0, null, data.generationResponses[ListLength(data.generationResponses)-1]) as suggest
    from $data
);

$formatUrl = ($url) -> {
    $url = String::AsciiToLower($url);
    $url = if(String::StartsWith($url, "http://"), Substring($url, Length("http://")), $url);
    $url = if(String::StartsWith($url, "https://"), Substring($url, Length("https://")), $url);
    $url = if(String::StartsWith($url, "www."), Substring($url, Length("www.")), $url);
    $url = if(
        String::Contains("/" || '?' || "&#", nvl(Substring($url, cast(Length($url) - 1 as uint32)), "none")),
        Substring($url, 0, cast(Length($url) - 1 as uint32)),
        $url);
    return $url;
};

$formatSitelink = ($sitelink) -> {
    RETURN AsStruct(
        $formatUrl($sitelink.url) as url,
        String::AsciiToLower($sitelink.title) as title
    );
};

$score_suggest = ($save, $suggest) -> {
    $save = ListMap($save, $formatSitelink);
    $suggest = ListMap(ListTake($suggest, 16), $formatSitelink);
    $suggestDict = ToDict(ListMap(ListTake($suggest, 8), ($s) -> {RETURN AsTuple($s.url, $s.title);}));
    $saveSuggestUrl = ListFilter($save, ($s) -> {RETURN DictContains($suggestDict, $s.url);});
    $saveSuggestTitle = ListFilter($saveSuggestUrl, ($s) -> {RETURN $s.title == DictLookup($suggestDict, $s.url);});
    RETURN AsStruct(
        ListLength($suggest) as suggest,
        ListLength($save) - ListLength($saveSuggestUrl) as add,
        ListLength($saveSuggestUrl) - ListLength($saveSuggestTitle) as upgrade,
        ListLength($saveSuggestTitle) as save
    );
};

$data = (
    select
        log_time,
        log_req_id,
        cid,
        saved,
        suggest.suggests as suggest,
        $score_suggest(saved, suggest.suggests) as nums,
        suggest.additionalInfo as additionalInfo
    from $data
);

$result = ($nums) -> {
    RETURN if(nvl($nums.suggest, 0) = 0, "none",
        if($nums.upgrade + $nums.save = 0, "useless",
        if($nums.add > 0, "notAll",
        if($nums.suggest - $nums.upgrade - $nums.save > 0, "extraLinks",
        if($nums.upgrade > 0, "good",
        "perfect"
    )))));
};

$detailed = (
    select
        log_time,
        log_req_id,
        cid,
        saved,
        suggest,
        nums.suggest as suggestNum,
        nums.add as manualAddNum,
        nums.upgrade as updateTitleAsdSaveSuggestedNum,
        nums.save as saveSuggestedNum,
        if(suggest is null, "NONE", if(ListLength(suggest) = 0, "EMPTY", "OK")) as type,
        $result(nums) as result,
        additionalInfo.requestUrl as url,
        additionalInfo.foundUrl as urlWithSitelinks
    from $data
);

insert into $insert_detailed_table with truncate
select
    log_time, log_req_id,
    cid, type, result, saved, suggest, suggestNum, manualAddNum, updateTitleAsdSaveSuggestedNum, saveSuggestedNum, url, urlWithSitelinks
from $detailed
order by log_time;

$urlNumStat = (
    select
        ListConcat(AsList(
            "suggest_sum=" || cast(sum(suggestNum) as String),
            "manual_add_sum_with_ok_suggest=" || cast(sum_if(manualAddNum, type = "OK") as String),
            "manual_add_sum_with_empty_suggest=" || cast(sum_if(manualAddNum, type = "EMPTY") as String),
            "save_suggest_sum=" || cast(sum(saveSuggestedNum) as String),
            "save_suggest_url_num=" || cast(sum(updateTitleAsdSaveSuggestedNum) as String),
        ), ";")
    from $detailed
);

$recNumStat = (
    select
        ListConcat(AGGREGATE_LIST("suggest_num_" || cast(suggestNum as String) || "=" || cast(cnt as String)), ";")
    from (
        select
            suggestNum, count(*) as cnt
        from $detailed
        group by suggestNum
    )
);

$addNumStat = (
    select
        ListConcat(AGGREGATE_LIST("manual_add_num_" || cast(manualAddNum as String) || "=" || cast(cnt as String)), ";")
    from (
        select
            manualAddNum, count(*) as cnt
        from $detailed
        group by manualAddNum
    )
);

$saveNumStat = (
    select
        ListConcat(AGGREGATE_LIST("save_suggest_num_" || cast(saveSuggestedNum as String) || "=" || cast(cnt as String)), ";")
    from (
        select
            saveSuggestedNum, count(*) as cnt
        from $detailed
        group by saveSuggestedNum
    )
);

$saveUrlNumStat = (
    select
        ListConcat(AGGREGATE_LIST("save_suggest_url_num_" || cast(updateTitleAsdSaveSuggestedNum as String) || "=" || cast(cnt as String)), ";")
    from (
        select
            updateTitleAsdSaveSuggestedNum, count(*) as cnt
        from $detailed
        group by updateTitleAsdSaveSuggestedNum
    )
);

$resultStat = (
    select
        ListConcat(AGGREGATE_LIST("result_" || result || "_num=" || cast(cnt as String)), ";")
    from (
        select
            result, count(*) as cnt
        from $detailed
        where suggestNum > 0
        group by result
    )
);

$summary = (
    select
        $day as day,
        count(*) as cases,
        count_if(type != "NONE") as requests,
        count_if(type not in ("NONE", "EMPTY")) as suggests,
        ";" || ListConcat(AsList(
            $resultStat,
            $urlNumStat,
            $recNumStat, $addNumStat, $saveNumStat, $saveUrlNumStat
        ), ";") || ";" as additional
    from $detailed
);

select * from $summary;

$summary = (
    select * from $summary
    where day not in (select day from $insert_summary_table where day = $day)
);

insert into $insert_summary_table
select day, cases, requests, suggests, additional from $summary;
