
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yt.Pool = ?;--test_value='default';
$output_path = ?;--test_value="//home/direct/tmp"
$shards = CAST(String::SplitToList(?, ',') AS List<String>);--test_value='1,2,3,21'
$cids = CAST(String::SplitToList(?, ',') AS List<Int64>);--test_value='53492335,52447948'

$ppcTable = ($table, $shard) -> {
    RETURN "home/direct/mysql-sync/current/ppc:" || CAST($shard AS String) || "/straight/" || $table;
};

$shardedTable = ($table) -> {
    RETURN ListMap($shards, ($i) -> {
        RETURN $ppcTable($table, $i);
    });
};
/*
Скрипт расчитывает потраченный и ожидаемый бюджет по кампании и складывает в $output_path
 */

$yson_get_int64 = ($yson_str, $key) -> {
    return Yson::LookupInt64(Yson::ParseJson($yson_str), $key);
};

$yson_get_str = ($yson_str, $key) -> {
    return Yson::LookupString(Yson::ParseJson($yson_str), $key);
};

$yson_get_double = ($yson_str, $key) -> {
    return Yson::LookupDouble(Yson::ParseJson($yson_str), $key);
};

$order_stat_day_table = "home/yabs/stat/OrderStatDay";
$currency_rate_table =  "home/direct/db/currency_rates";

INSERT INTO $output_path WITH TRUNCATE
    SELECT
        campaigns.cid AS cid,
        campaigns.currency_rate_coef AS currency_rate,
        campaigns.currency AS currency,
        CAST(sum_spent_raw AS Double)/(1.0 + Nds/100.0) AS sum_spent,
        CAST(CostCur AS Double)/10000/(1.0 + Nds/100.0) AS sum_spent_by_day,
        strategy_budget * 1.0 / strategy_period AS sum_estimated_by_day
    FROM (
        SELECT
            campaigns_sync.cid as cid,
            campaigns_sync.start_time as start_time,
            strategy_data,
            -- campaign finish date depends on strategy and its auto_prolongation flag
            IF(strategy_name IN ('autobudget_max_impressions_custom_period', 'autobudget_max_reach_custom_period', 'autobudget_avg_cpv_custom_period')
                    AND (
                        $yson_get_int64(strategy_data, "auto_prolongation") == 0
                        OR finish_time == '0000-00-00'
                        OR finish_time IS NULL
                    ),
                $yson_get_str(strategy_data, "finish"),
                finish_time) AS finish_time,
            brand_survey_id,
            campaigns_sync.currency AS currency,
            CASE
                WHEN campaigns_sync.currency = 'YND_FIXED' THEN 30
                WHEN campaigns_sync.currency = 'RUB' THEN 1
                WHEN rates.rate IS NOT NULL THEN CAST(rates.rate AS Double)
                ELSE 1
            END as currency_rate_coef,
            sum_spent as sum_spent_raw,
            NVL(CostCur, CostCur, 0) AS CostCur,
            NVL(agency_nds.nds, NVL(client_nds.nds, 0.0)) AS Nds,
            CASE
                WHEN strategy_name = 'cpm_default' THEN CAST(day_budget AS Double)
                WHEN strategy_name IN ('autobudget_max_impressions', 'autobudget_max_reach', 'autobudget_avg_cpv') THEN $yson_get_double(strategy_data, "sum")
                WHEN strategy_name IN ('autobudget_max_impressions_custom_period', 'autobudget_max_reach_custom_period',
                'autobudget_avg_cpv_custom_period') THEN $yson_get_double(strategy_data, "budget")
                ELSE NULL
            END AS strategy_budget,
            CASE
                WHEN strategy_name = 'cpm_default' THEN 1
                WHEN strategy_name IN ('autobudget_max_impressions', 'autobudget_max_reach', 'autobudget_avg_cpv') THEN 7
                WHEN strategy_name IN ('autobudget_max_impressions_custom_period', 'autobudget_max_reach_custom_period',
                'autobudget_avg_cpv_custom_period')
                    THEN DateTime::ToDays(
                        DateTime::MakeDate(DateTime::ParseIso8601($yson_get_str(strategy_data, "finish")))
                        - DateTime::MakeDate(DateTime::ParseIso8601($yson_get_str(strategy_data, "start")))) + 1
                ELSE NULL
            END AS strategy_period
        FROM
            EACH($shardedTable('campaigns')) AS campaigns_sync
        JOIN
            EACH($shardedTable('camp_options')) AS camp_opt_table
        ON
            campaigns_sync.cid = camp_opt_table.cid
        LEFT JOIN
            (
                SELECT
                    currency,
                    MAX_BY(rate, `date`) as rate
                FROM
                    $currency_rate_table
                GROUP BY
                    currency
            ) AS rates
        ON
            rates.currency = campaigns_sync.currency
        LEFT JOIN
            (
                SELECT
                    CostCur,
                    OrderID
                FROM
                    $order_stat_day_table
                WHERE
--                  Дата и в UpdateTime и в CurrentUtcDate() в одной таймзоне UTC
--                  Так как OrderStatDay в таблице работает в UTC, то 5 июля в 21:00 (дата в таблице)
--                  они записывают данные за весь день 6 июля.
--                  То есть надо искать в UTC данные в интервале между (сейчас - 2 дня) и (сейчас - 1 день)
                    UpdateTime >= DateTime::ToSeconds(CurrentUtcDate())-172800 AND
                    UpdateTime < DateTime::ToSeconds(CurrentUtcDate())-86400 AND
                    IsSearch=false
            ) AS orderstat
        ON
            orderstat.OrderID = campaigns_sync.OrderID
        LEFT JOIN
            (
                SELECT
                    ClientID,
                    SOME(CAST(nds AS Double)) AS nds
                FROM EACH($shardedTable('client_nds')) AS client_nds
                WHERE CAST(date_from AS date) <= CurrentUtcDate() AND CurrentUtcDate() <= CAST(date_to AS date)
                GROUP BY ClientID
            ) AS client_nds
        ON
            campaigns_sync.ClientID = client_nds.ClientID
        LEFT JOIN
            (
                SELECT
                    ClientID,
                    SOME(CAST(nds AS Double)) AS nds
                FROM EACH($shardedTable('agency_nds')) AS agency_nds
                WHERE CAST(date_from AS date) <= CurrentUtcDate() AND CurrentUtcDate() <= CAST(date_to AS date)
                GROUP BY ClientID
            ) AS agency_nds
            ON
                campaigns_sync.AgencyID = agency_nds.ClientID
        WHERE (campaigns_sync.cid IN $cids OR (NOT ListHasItems($cids) AND campaigns_sync.type != 'cpm_price'))
        ) AS campaigns
    WHERE brand_survey_id IS NOT NULL
        AND (finish_time IS NULL OR finish_time == "0000-00-00" OR CAST(finish_time AS Date) >= CurrentUtcDate())
        AND CAST(start_time AS Date) <= CurrentUtcDate();
