$logs_table = ?;
$parsed_data_table = ?;

$replace = Re2::Replace("[^0-9]");

$log = (select
    Url::HostNameToPunycode(Url::CutWWW(Url::GetHost(referer))) as domain,
    counterid as counterId,
    Url::Decode(url) as raw_tel,
    $replace(Url::Decode(url), '') as tel
from $logs_table
where (Metrika::ParseBrowserinfo(browserinfo)['ln'] = '1')
    and (url like 'tel:%'));

insert into $parsed_data_table
with truncate
         select
             domain,
             counterId,
             '+7' || substring(tel, 1, cast((length(tel) - 1) as UInt32)) as tel,
             clicks
         from
             (select
                  domain,
                  counterId,
                  tel,
                  count(*) as clicks
              from $log
              where (domain is not Null)
                and (length(tel) = 11)
                and (substring(tel, 0, 1) in ('7', '8'))
              group by
                  domain,
                  counterId,
                  tel);
