$logs_table = ?;
$parsed_data_table = ?;

$script = @@
import json

def get_scripts(s):
    try:
        return json.loads(s)['scripts'].keys()
    except:
        return []
@@;

$scripts = Python2::get_scripts(
    CallableType(0, ParseType('List<String>'), ParseType('String?')),
    $script
);

$script_hits = (
    select *
    from
        (select
            $scripts(params) as script,
            watchid as watch_id,
            Url::CutWWW(Url::GetHost(url)) as domain
        from $logs_table
        where (counterid = '51533966') and (counterclass = '0')) -- Счетчик 51533966 - это специальный технический счетчик Метрики, на котором собираются в параметры визитов все скрипты, которые грузятся на сайтах с Метрикой
    flatten list by script
);

insert into $parsed_data_table
with truncate
    select
        domain,
        script_type,
        count(distinct watch_id) as hits
    from
        (select
        domain,
        watch_id,
        case
            when Url::GetHost(script) like '%app.comagic.ru%' then 'comagic'
            when Url::GetHost(script) like '%mod.calltouch.ru%' then 'calltouch'
            when (Url::GetHost(script) like '%roistat%') and (script like '%/get-phone%') then 'roistat'
            when Url::GetHost(script) like '%analytics.alloka.ru%' then 'alloka'
            when Url::GetHost(script) like '%ringostat.com%' then 'ringostat'
            when Url::GetHost(script) like '%widgets.mango-office.ru%' then 'mango-office'
            when Url::GetHost(script) like '%counter.quon.ru%' then 'quon'
            when Url::GetHost(script) like '%k50-a.akamaihd.net%' then 'k50'
            when Url::GetHost(script) like '%cc.calltracking.ru%' then 'calltracking.ru'
            when Url::GetHost(script) like '%primegate%' then 'primegate'
            when Url::GetHost(script) like '%cdn.callibri.ru%' then 'callibri'
            when Url::GetHost(script) like '%crm.hotlead.io%' then 'hotlead'
            when script like '%completo.ru/api/shoko/client.js%' then 'phonetrack'
            when Url::GetHost(script) like '%zebratelecom.ru%' then 'zebratelecom'
            when Url::GetHost(script) like '%app.uiscom.ru%' then 'uiscom'
            when Url::GetHost(script) like '%utmstat.com%' then 'utmstat'
            when Url::GetHost(script) like '%eyenewton.ru%' then 'eyenewton'
            when Url::GetHost(script) like '%lptracker.ru%' then 'lptracker'
            else 'other'
        end as script_type
        from $script_hits)
    where script_type != 'other' and domain is not null
    group by
        domain,
        script_type;
