$logs_table = ?;
$parsed_data_table = ?;

$script = @@
import json

def get_phones(params):
    try:
        recs = []

        phc = json.loads(params)['__ym']['phc']
        client_id = phc['clientId']
        order_id = phc['orderId']
        phones = phc['phones']

        for from_phone in phones:
            for to_phone in phones[from_phone]:
                recs.append(
                    {
                        'client_id': str(client_id),
                        'order_id': str(order_id),
                        'from_phone': str(from_phone),
                        'to_phone': str(to_phone),
                        'num_changes': str(phones[from_phone][to_phone])
                    }
                )
        return recs
    except:
        return []
@@;

$phones = Python2::get_phones(
    CallableType(0, ParseType('List<Dict<String,String>>'), ParseType('String?')),
    $script
);

$ct_changes = (
    select
        params,
        counterid,
        phones['client_id'] as client_id,
        phones['order_id'] as order_id,
        phones['from_phone'] as from_phone,
        phones['to_phone'] as to_phone,
        cast(phones['num_changes'] as UInt64) as num_changes
    from
        (select
            params,
            counterid,
            $phones(params) as phones
        from $logs_table
        where params != '')
    flatten by phones
);

insert into $parsed_data_table
with truncate
         select
             client_id,
             counterid,
             from_phone,
             count(*) as hits,
             sum(num_changes) as changes
         from $ct_changes
         group by
             client_id,
             counterid,
             from_phone;
