$for_oneshot = ?;
$for_rollback_oneshot = ?;
$EVENT_ID = ?;
$ShowAfter = ?;
$Expired = ?;
$Text = ?;
$Title = ?;
$ButtonText = ?;
$ButtonHref = ?;
$Image = ?;

$users = ?;
$users = %s;

$users = (
    select distinct uid, ClientID, login
    from `//home/direct/db/users`
    where %s in $users
);

$MESSAGE_TEMPLATE = @@
{
	"slides":[{
		"header":{
			"image":"__IMAGE__"
		},
		"body":{
			"title":"__TEXT__",
			"text":"__TITLE__"
		},
		"footer":{
			"buttons":[{
				"id":1,
				"text":"__BUTTON_TEXT__",
				"view":"action",
				"href":"__BUTTON_HREF__",
				"action":"actionLink",
				"inline":false
			}]
		}
	}]
}
@@;

$MESSAGE =
        String::ReplaceAll(
        String::ReplaceAll(
        String::ReplaceAll(
        String::ReplaceAll(
        String::ReplaceAll(
            $MESSAGE_TEMPLATE,
        "__TEXT__", $Text),
        "__TITLE__", $Title),
        "__BUTTON_TEXT__", $ButtonText),
        "__BUTTON_HREF__", $ButtonHref),
        "__IMAGE__", $Image);

$Timestamp = DateTime::ToSeconds(CurrentUtcTimestamp());
$PRIORITY = 1; -- влияет на порядок сообщений в стопке. Сначала показываются сообщения с большим приоритетом.
$COMMUNICATION_TYPE = "INFORMATION"; -- Еще не используется. MARKETING/INFORMATION/TRIGGER/UNRESTRICTED смотреть значения тут https://a.yandex-team.ru/arc/trunk/arcadia/ads/bsyeti/libs/communications/proto/common.proto
$MESSAGE_TYPE = "ALERT"; -- Еще не используется. ALERT/INFO/POLL/RECOMMENDATION смотреть значения тут https://a.yandex-team.ru/arc/trunk/arcadia/ads/bsyeti/libs/communications/proto/common.proto
$SLOT_TYPE = "TOP"; -- Еще не используется. смотреть значения тут https://a.yandex-team.ru/arc/trunk/arcadia/ads/bsyeti/libs/communications/proto/common.proto



$SEND_EVENT = @@
{
    "Uids": [__userId__],
    "Timestamp": __Timestamp__,
    "Data": {
        "Id": __EVENT_ID__,
        "Type": "SEND_MESSAGE",
        "Source": {
            "Type": "DIRECT_ADMIN",
            "Id": 2
        },
        "CommunicationType": "__COMMUNICATION_TYPE__",
        "SendMessage": {
            "Channels": ["DIRECT_WEB_UI"],
            "Expired": __Expired__,
            "DirectWebData": {
                "MessageText": "__MESSAGE_TEXT__",
                "ShowAfter": __ShowAfter__,
                "Priority": __PRIORITY__,
                "MessageFormat": "RICH",
                "MessageType": "__MESSAGE_TYPE__",
                "Slot": "__SLOT_TYPE__"
            }
        }
    }
}
@@;

$CLEAR_EVENT = @@
{
    "Uids": [__userId__],
    "Timestamp": __Timestamp__,
    "Data": {
        "Id": 1,
        "Type": "CLEAR_MESSAGES",
        "Source": {
            "Type": "DIRECT_ADMIN",
            "Id": 2
        },
        "CommunicationType": "__COMMUNICATION_TYPE__",
        "ClearMessages": {
            "TargetChannels": ["DIRECT_WEB_UI"],
            "TargetEventIds": [__EVENT_ID__]
        }
    }
}
@@;

$toString = ($value) -> {RETURN nvl(cast($value as String), "");};

$getClearEvent = ($uid) -> {
    RETURN
        String::ReplaceAll(
        String::ReplaceAll(
        String::ReplaceAll(
        String::ReplaceAll(
            $CLEAR_EVENT,
        "__userId__", $toString($uid)),
        "__Timestamp__", $toString($Timestamp)),
        "__EVENT_ID__", $toString($EVENT_ID)),
        "__COMMUNICATION_TYPE__", $COMMUNICATION_TYPE);
};

$getSendEvent = ($uid, $clientId) -> {
    $MESSATE_TEXT =
        String::ReplaceAll(
        String::ReplaceAll(
            $MESSAGE,
        "\\", "\\\\"),
        "\"", "\\\"");
    RETURN
        String::ReplaceAll(
        String::ReplaceAll(
        String::ReplaceAll(
        String::ReplaceAll(
        String::ReplaceAll(
        String::ReplaceAll(
        String::ReplaceAll(
        String::ReplaceAll(
        String::ReplaceAll(
        String::ReplaceAll(
        String::ReplaceAll(
            $SEND_EVENT,
        "__userId__", $toString($uid)),
        "__Timestamp__", $toString($Timestamp)),
        "__EVENT_ID__", $toString($EVENT_ID)),
        "__COMMUNICATION_TYPE__", $COMMUNICATION_TYPE),
        "__Expired__", $toString($Expired)),
        "__MESSAGE_TEXT__", $MESSATE_TEXT),
        "__ShowAfter__", $toString($ShowAfter / 60)),
        "__PRIORITY__", $toString($PRIORITY)),
        "__MESSAGE_TYPE__", $MESSAGE_TYPE),
        "__SLOT_TYPE__", $SLOT_TYPE),
        "__clientId__", $toString($clientId));
};

insert into $for_oneshot with truncate
select
    uid as Uid, ClientID, $getSendEvent(uid, ClientID) as Event
from $users;

insert into $for_rollback_oneshot with truncate
select
    uid as Uid, ClientID, $getClearEvent(uid) as Event
from $users;
