PRAGMA AnsiInForEmptyOrNullableItemsCollections;
PRAGMA yt.MaxKeyWeight = "262144";

$table_list = ?;
$base_folder = ?;

$now = CAST((DateTime::ToSeconds(CurrentUtcTimestamp()) / 3600) * 3600 AS UInt32);
$dst = $base_folder || "/export/content_categories/mobile_apps/categories/mobile_apps_categories_" || CAST($now AS STRING);
$gplay_categories =  $base_folder || "/export/content_categories/mobile_apps/gplay_categories";
$itunes_categories = $base_folder || "/export/content_categories/mobile_apps/itunes_categories";
$apps_categories_mapping = $base_folder || "/export/content_categories/mobile_apps/categories_mapping";

$sources = (
    SELECT
        urlmd5,
        url,
        app_id
    FROM EACH(String::SplitToList($table_list, ",")) AS s
    WHERE in_app);

$joined = (
    SELECT
        s.urlmd5 AS urlmd5,
        s.url AS url,
        g.genres AS genres
    FROM $sources AS s
    LEFT JOIN $gplay_categories AS g ON g.app_id = s.app_id
    WHERE g.app_id IS NOT NULL
    UNION ALL
    SELECT
        s.urlmd5 AS urlmd5,
        s.url AS url,
        i.genres AS genres
    FROM $sources as s
    LEFT JOIN $itunes_categories as i ON i.bundle = s.app_id
    WHERE i.bundle IS NOT NULL);


INSERT INTO $dst WITH TRUNCATE
SELECT
    j.urlmd5 AS urlmd5,
    j.url AS url,
    AGGREGATE_LIST_DISTINCT(m.keyword_value) AS catalogia_cats,
    AGGREGATE_LIST_DISTINCT(m.keyword_value) AS categories,
    "mobile_app" AS source
FROM(
    SELECT
        urlmd5,
        url,
        cat
    FROM $joined AS j
    FLATTEN LIST BY genres AS cat) AS j
JOIN $apps_categories_mapping AS m ON m.app_category = j.cat
GROUP BY j.urlmd5, j.url;
