PRAGMA yt.Pool = ?;

$src_tables = ?;
$dst_table = ?;
$service = ?;
$limit = ?;

$row_count = SELECT COUNT(*) FROM EACH(String::SplitToList($src_tables, ","));

INSERT INTO @data
SELECT
    CAST(urlmd5 AS Optional<UInt64>) AS urlmd5,
    url,
    NVL(ListMap(categories, ($x) -> { RETURN '"' || $x || '"' }), ListCreate(String)) AS BrandSafetyTags,
    $service AS service
FROM EACH(String::SplitToList($src_tables, ","))
WHERE url IS NOT NULL;

COMMIT;

INSERT INTO $dst_table
    SELECT
        urlmd5,
        COALESCE(url, "") AS url,
        BrandSafetyTags,
        service
    FROM @data
    SAMPLE IF($limit < $row_count, CAST($limit AS Double) / $row_count, 1.0)
