PRAGMA yt.Pool = ?;

$src_table = ?;
$dst_table = ?;
$executed_projects_table = ?;
$categories_str_list = ?;
$categories_group = ?;
$limit = ?;

$categories = String::SplitToList($categories_str_list, ",");

INSERT INTO $dst_table WITH TRUNCATE
    SELECT
        urlmd5,
        url
    FROM (
        SELECT
            src.urlmd5 AS urlmd5,
            url,
            cost
        FROM $src_table AS src
        LEFT JOIN (
            SELECT
                urlmd5,
                AGGREGATE_LIST_DISTINCT(project) AS projects
            FROM $executed_projects_table
            GROUP BY urlmd5
        ) AS executed_projects USING(urlmd5)
        WHERE
            NOT SetIncludes(ToSet(NVL(catalogia_cats, ListCreate(String))), ToSet($categories))
            AND (projects IS NULL OR NOT ListHas(projects, $categories_group))
            AND NOT in_app
        ORDER BY cost DESC
        LIMIT $limit
    );
