PRAGMA yt.Pool = ?;

$src_table = ?;
$category_id = ?;
$folder_name = ?;
$base_folder = ?;
$limit = ?;

$start = SELECT (DateTime::ToSeconds(CurrentTzDatetime("Europe/Moscow")) / 3600) * 3600;
$executed_projects = $base_folder || "/export/content_categories/toloka/executed_projects_by_url";
$dst = $base_folder || "/export/content_categories/toloka/input_second_lvl/" || $folder_name || "/input_bs_" || CAST($start AS String);

INSERT INTO $dst WITH TRUNCATE
SELECT
    urlmd5,
    url
FROM (
    SELECT
        s.urlmd5 AS urlmd5,
        url,
        weight
    FROM $src_table AS s
    LEFT JOIN (
        SELECT urlmd5
        FROM $executed_projects
        WHERE project = $folder_name) AS p ON p.urlmd5 = s.urlmd5
    WHERE NOT in_app
      AND url IS NOT NULL
      AND p.urlmd5 IS NULL
      AND ListHas(categories, $category_id)
    ORDER BY weight DESC
    LIMIT $limit)
