$table_list = ?;
$dst_table = ?;

-- "\"4294968296\"" to "4294968296"
$remove_quotes = ($str) -> { RETURN String::RemoveFirst(String::RemoveLast($str, '"'), '"'); };

-- разложить списки категорий урлов, убрав кавычки
$flattened_content_categories = (
    SELECT
        urlmd5,
        $remove_quotes(ContentCategory) AS ContentCategory
    FROM (
        SELECT
            urlmd5,
            Yson::ConvertToStringList(Yson::Parse(ContentCategories)) AS ContentCategories
        FROM EACH(String::SplitToList($table_list, ","))
    )
    FLATTEN LIST BY ContentCategories AS ContentCategory
);

-- маппить категории, добавив "Остальное" где нужно и собрать в список для каждого урла
$content_categories_by_urlmd5 = (
    SELECT
        urlmd5,
        AGGREGATE_LIST_DISTINCT(keywords) AS ContentCategories
    FROM (
        SELECT
            A.urlmd5 AS urlmd5,
            B.mapped_keywords AS keywords
        FROM $flattened_content_categories AS A
        JOIN `//home/direct/export/content_categories/toloka/toloka_categories_mapping` AS B ON A.ContentCategory == B.bb_keyword_value
    )
    FLATTEN LIST BY keywords
    GROUP BY urlmd5
);

$bs_categories_by_urlmd5 = (
    SELECT
        urlmd5,
        AGGREGATE_LIST_DISTINCT($remove_quotes(BrandSafetyTags)) AS BrandSafetyTags
    FROM (
        SELECT
            urlmd5,
            Yson::ConvertToStringList(Yson::Parse(BrandSafetyTags)) AS BrandSafetyTags
        FROM EACH(String::SplitToList($table_list, ","))
    )
    FLATTEN LIST BY BrandSafetyTags
    GROUP BY urlmd5
);

-- присоединение к категориям каталогии, удаление кавычек у кейвордов категорий BS
INSERT INTO $dst_table WITH TRUNCATE
    SELECT
        u.urlmd5 AS urlmd5,
        url,
        ListExtend(
            NVL(cc.ContentCategories, ListCreate(String)),
            NVL(bs.BrandSafetyTags, ListCreate(String))
        ) AS catalogia_cats,
        ListExtend(
            NVL(cc.ContentCategories, ListCreate(String)),
            NVL(bs.BrandSafetyTags, ListCreate(String))
        ) AS categories,
        "toloka" AS source
    FROM (
        SELECT
            urlmd5,
            SOME(url) AS url,
        FROM EACH(String::SplitToList($table_list, ","))
        GROUP BY urlmd5
    ) AS u
    LEFT JOIN $content_categories_by_urlmd5 AS cc ON u.urlmd5 == cc.urlmd5
    LEFT JOIN $bs_categories_by_urlmd5 AS bs ON u.urlmd5 == bs.urlmd5
