$logs_table = ?;
$private_logs_table = ?;
$parsed_data_table = ?;

$log = (
    select
        CAST(Unicode::ToLower(CAST(NVL(Url::PunycodeToHostName(URLDomain), URLDomain) as UTF8)) as String) as domain,
        UserID as user_id,
        cast(CounterID as UInt64) as counter_id
    from concat($logs_table, $private_logs_table)
    where (nvl(CounterClass, 0) = 0)
        and not nvl(DontCountHits, False)
);

$log_filt = (
    select log.*
    from
        $log as log
        left only join
        `//home/metrika/export/counters_black_list` as black_list
        on (log.counter_id = black_list.CounterID)
);

$log_counters = (
    select
        domains_table.domain as domain,
        counter_id,
        users,
        domain_users,
        Url::GetSignificantDomain(domains_table.domain) as significant_domain,
        if(
            (domains_table.domain like '%.turbo.site') or (domains_table.domain like '%.yandex.%'),
            Null, domains_table.domain
        ) as not_yandex_domain,
        if(
            (domains_table.domain like '%.turbo.site') or (domains_table.domain like '%.yandex.%'),
            Null, Url::GetSignificantDomain(domains_table.domain)
        ) as not_yandex_significant_domain
    from
        (select
            domain,
            CountDistinctEstimate(user_id) as domain_users
        from $log_filt
        group by domain) as domains_table
        inner join
        (select
            domain,
            counter_id,
            CountDistinctEstimate(user_id) as users
        from $log_filt
        group by
            domain,
            counter_id) as counters_table
        using (domain)
);

$domains_per_counter = (
    select
        counter_id,
        count(distinct not_yandex_domain) as num_domains_on_counter,
        count(distinct not_yandex_significant_domain) as num_significant_domains_on_counter
    from $log_counters
    group by counter_id
);

insert into $parsed_data_table
with truncate
    select
        domain,
        log.counter_id as counter_id,
        owner,
        nvl(users, 0) as num_counter_users,
        nvl(domain_users, 0) as num_domain_users,
        nvl(num_domains_on_counter, 0) as num_domains_on_counter,
        nvl(num_significant_domains_on_counter, 0) as num_significant_domains_on_counter,
        nvl(bl.Result, '') as black_list_result,
        nvl(mrkp.Result, '') as markup_result
from
    $log_counters as log
    inner join
    (select
        counter_id,
        owner
    from `//home/metrika/export/counters`
    where status = 'Active') as counters
    on (log.counter_id = counters.counter_id)
    inner join $domains_per_counter as domains
    on (log.counter_id = domains.counter_id)
    left join `//home/metrica-analytics/black_list/counters_black_list_latest` as bl
    on (log.counter_id = bl.CounterID)
    left join `//home/metrica-analytics/black_list/counters_markup_latest` as mrkp
    on (log.counter_id = mrkp.CounterID);
