$logs_table = ?;
$parsed_data_table = ?;

$log = (
    select
        NVL(Url::PunycodeToHostName(Url::CutWWW(Url::GetHost(url))), Url::CutWWW(Url::GetHost(url))) as domain,
        if(uniqid = '0',
            if (UserAgent::Parse(useragent).ITP,
                cast(domainuserid as UInt64),
                Digest::SipHash(0, 0, Ip::FromString(clientip6) || useragent)
            ), cast(uniqid as UInt64)
        ) as user_id,
        cast(counterid as UInt64) as counter_id
    from $logs_table
    where (counterclass = '0')
        and (Metrika::ParseBrowserinfo(browserinfo)['pv'] = '1')
);

$log_filt = (
    select log.*
    from
        $log as log
        left only join
        `//home/metrika/counters_black_list` as black_list
        using (counter_id)
);

$log_counters = (
    select
        domains_table.domain as domain,
        counter_id
    from
        (select
            domain,
            CountDistinctEstimate(user_id) as domain_users
        from $log_filt
        group by domain) as domains_table
        inner join
        (select
            domain,
            counter_id,
            CountDistinctEstimate(user_id) as users
        from $log_filt
        group by
            domain,
            counter_id) as counters_table
        using (domain)
    where (users >= 0.1 * domain_users)
        and (domain_users >= 10)
);

insert into $parsed_data_table
with truncate
    select
        CAST(Unicode::ToLower(CAST(log.domain as UTF8)) as String) as domain,
        log.counter_id as counter_id,
        owner
    from
    $log_counters as log
    inner join
    (select
        counter_id,
        owner
    from `//home/metrika/export/counters`
    where status = 'Active') as counters
    using (counter_id);
