SELECT
    any(log_time),
    bid,
    visitParamExtractString(data, 'type') AS type,
    max(concat(toString(JSONExtractInt(data, 'meta', 'version_id')), IF(action = 'request', 'A', 'B'))) AS version
FROM ess_moderation
WHERE (xxHash32(concat(toString(bid), visitParamExtractString(data, 'type'))) % %(slices_count) = %(slice_number))
    AND (JSONExtractString(data, 'circuit') != 'bs')
    AND (log_date >= (toDate('%(now)') - %(window)))
    AND (log_time > (toDateTime('%(now)') - ((%(window) * 24) * 3600)))
    AND ( (action = 'response')
          OR (log_time < (toDateTime('%(now)') - (%(sla) * 3600))))
    AND (type NOT IN ('adgroup', 'campaign_sm'))
    AND visitParamHas(data, 'meta')
GROUP BY (bid, type)
HAVING endsWith(version, 'A') = 1
