PRAGMA yt.Pool = ?;--test_value='default';

$agency_id = ?;--test_value=62197708;
$date_from = ?;--test_value="2021-12-01";
$date_to = ?;--test_value="2022-01-31";
$show_all_client = ?;--test_value=1;
--Пример запроса: https://yql.yandex-team.ru/Operations/YgQhzVZ1O6hhT8Kg8HGzzwXbCWWr4Dbc8o9eCKA6sSg=

$report_table = "//home/search-research/yateika/rewards/ga-247/report_base";

$rewards = (
    SELECT
        String::JoinFromList(AGGREGATE_LIST_DISTINCT(contract_eids), ",") AS contract_eids,
        r.client_id AS client_id,
        String::JoinFromList(AGGREGATE_LIST_DISTINCT(CAST(client_name AS String)), "; ") AS client_name,
        r.cid AS cid,
        String::JoinFromList(AGGREGATE_LIST_DISTINCT(cid_name), "; ") AS campaign_name,
        SUM(NVL(show_amount, 0)) AS total_amount,
        SUM(NVL(rsya_show_amount, 0)) AS rsya_amount,
        String::JoinFromList(AGGREGATE_LIST_DISTINCT(counters_rate), "; ") AS counters_rate,
        String::JoinFromList(AGGREGATE_LIST_DISTINCT(goals_rate), "; ") AS goals_rate,
        String::JoinFromList(CAST(AGGREGATE_LIST_DISTINCT(Math::Round(click_visit_rate, -6)) AS List<String>), "; ") AS click_visit_rate,
        SUM(NVL(metrika_show_amount, 0)) AS metrika_amount,
        SUM(NVL(metrika_and_goals_show_amount, 0)) AS metrika_and_goals_amount,
        SUM(NVL(autobudget_avg_show_amount, 0)) AS autobudget_avg_amount,
        SUM(NVL(autotarget_search_show_amount, 0)) AS autotarget_search_amount
    FROM $report_table AS r
    WHERE `date` BETWEEN $date_from and $date_to
        AND agency_id = $agency_id
        AND cpc_direct_flag
        AND ($show_all_client = 1 OR r.client_id IN ParseFile("Int64", "client_ids.txt"))
    GROUP BY r.client_id, r.cid
);

SELECT contract_eids,
       r.client_id AS client_id,
       u1.login AS client_login,
       client_name,
       u2.login AS representative_login,
       cid,
       campaign_name,
       total_amount,
       rsya_amount,
       IF (total_amount = 0, 0, Math::Round(rsya_amount / total_amount, -6)) AS rsya_rate,
       counters_rate,
       goals_rate,
       click_visit_rate,
       metrika_amount,
       metrika_and_goals_amount,
       autobudget_avg_amount,
       autotarget_search_amount
FROM $rewards AS r
INNER JOIN `//home/direct/db/clients` AS c ON c.ClientID = r.client_id
INNER JOIN `//home/direct/db/users` AS u1 ON u1.uid = c.chief_uid
LEFT JOIN `//home/direct/db/users` AS u2 ON u2.uid = c.agency_uid
ORDER BY client_id, cid
