PRAGMA yt.Pool = ?;--test_value='default';

$agency_id = ?;--test_value=350487;
$date_from = ?;--test_value="2021-03-01";
$date_to = ?;--test_value="2021-03-10";
$show_all_client = ?;--test_value=1;
$table_name = ?;--test_value="report";
--Пример запроса для premium: https://yql.yandex-team.ru/Operations/Yg_afa5OD3u9QC9cYHcR0GsAE7Qz-481rFszzQjKuSI=
--Пример запроса для aggregator: https://yql.yandex-team.ru/Operations/Yg_lnwVK8CgkKBhWNtFQojCl2uyQ3cBa_STLR-zA4p8=

$report_table = "//home/search-research/yateika/rewards/ga-247/" || $table_name;

$k50 = (
    SELECT
        client_id,
        k50_effective_actions_rate,
        SUM(NVL(k50_efficient_dayse_show_amount, 0)) AS k50_efficient_amount
    FROM $report_table
    WHERE `date` BETWEEN $date_from AND $date_to
        AND agency_id = $agency_id
        AND ($show_all_client = 1 OR client_id IN ParseFile("Int64", "client_ids.txt"))
    GROUP BY client_id, k50_effective_actions_rate
);

$domains_by_cid = (
    SELECT
        client_id,
        cid,
        ar_domain,
        ar_domain || ', ' || CAST(Math::Round(SUM(NVL(show_amount, 0)), -2) AS String) AS domain_total_amount,
        ar_domain || ', ' || CAST(Math::Round(SUM(NVL(rsya_show_amount, 0)), -2) AS String) AS domain_rsya_amount
    FROM $report_table
    WHERE `date` BETWEEN $date_from AND $date_to
        AND agency_id = $agency_id
        AND cpc_direct_flag
        AND ($show_all_client = 1 OR client_id IN ParseFile("Int64", "client_ids.txt"))
    GROUP BY client_id, cid, ar_domain
);

$domains = (
    SELECT
        ar_domain,
        ar_domain || ', ' || CAST(IF (SUM(NVL(show_amount, 0)) = 0, 0, Math::Round(SUM(NVL(rsya_show_amount, 0)) / SUM(NVL(show_amount, 0)), -3)) AS String) AS domain_rsya_rate
    FROM $report_table
    WHERE `date` BETWEEN $date_from AND $date_to
        AND agency_id = $agency_id
        AND cpc_direct_flag
    GROUP BY ar_domain
);

$rewards = (
    SELECT
        String::JoinFromList(AGGREGATE_LIST_DISTINCT(contract_eids), ",") AS contract_eids,
        r.client_id AS client_id,
        String::JoinFromList(AGGREGATE_LIST_DISTINCT(client_name), "; ") AS client_name,
        r.cid AS cid,
        String::JoinFromList(AGGREGATE_LIST_DISTINCT(cid_name), "; ") AS campaign_name,
        SUM(NVL(show_amount, 0)) AS total_amount,
        String::JoinFromList(ListSort(AGGREGATE_LIST_DISTINCT(r.ar_domain)), "; ") AS domain_name,
        String::JoinFromList(ListSort(AGGREGATE_LIST_DISTINCT(dc.domain_total_amount)), "; ") AS domain_total_amount,
        String::JoinFromList(ListSort(AGGREGATE_LIST_DISTINCT(dc.domain_rsya_amount)), "; ") AS domain_rsya_amount,
        String::JoinFromList(ListSort(AGGREGATE_LIST_DISTINCT(d.domain_rsya_rate)), "; ") AS domain_rsya_rate,
        String::JoinFromList(AGGREGATE_LIST_DISTINCT(counters_rate), "; ") AS counters_rate,
        String::JoinFromList(AGGREGATE_LIST_DISTINCT(goals_rate), "; ") AS goals_rate,
        String::JoinFromList(CAST(AGGREGATE_LIST_DISTINCT(Math::Round(click_visit_rate, -6)) AS List<String>), "; ") AS click_visit_rate,
        SUM(NVL(metrika_show_amount, 0)) AS metrika_amount,
        SUM(NVL(metrika_and_goals_show_amount, 0)) AS metrika_and_goals_amount,
        SUM(NVL(autobudget_avg_show_amount, 0)) AS autobudget_avg_amount,
        SUM(NVL(cpc_video_show_amount, 0)) AS cpc_video_amount,
        SUM(NVL(mobile_content_show_amount, 0)) AS mobile_content_amount,
        SUM(NVL(performance_show_amount, 0)) AS performance_amount,
        SUM(NVL(product_gallery_show_amount, 0)) AS product_gallery_amount, --значение не используется для aggregator
        String::JoinFromList(CAST(AGGREGATE_LIST_DISTINCT(Math::Round(k.k50_effective_actions_rate, -6)) AS List<String>), "; ") AS k50_effective_actions_rate,
        String::JoinFromList(CAST(AGGREGATE_LIST_DISTINCT(Math::Round(k.k50_efficient_amount, -2)) AS List<String>), "; ") AS k50_efficient_amount,
        SUM(NVL(retarget_show_amount, 0)) AS retargeting_amount,
        SUM(NVL(autotarget_search_show_amount, 0)) AS autotarget_search_amount
    FROM $report_table AS r
    LEFT JOIN $k50 AS k ON k.client_id = r.client_id
    LEFT JOIN $domains_by_cid AS dc ON dc.client_id = r.client_id AND dc.cid = r.cid AND dc.ar_domain = r.ar_domain
    LEFT JOIN $domains AS d ON d.ar_domain = r.ar_domain
    WHERE `date` BETWEEN $date_from and $date_to
        AND agency_id = $agency_id
        AND cpc_direct_flag
        AND ($show_all_client = 1 OR r.client_id IN ParseFile("Int64", "client_ids.txt"))
    GROUP BY r.client_id, r.cid
);

SELECT contract_eids,
       r.client_id AS client_id,
       u1.login AS client_login,
       client_name,
       u2.login AS representative_login,
       cid,
       campaign_name,
       total_amount,
       domain_name,
       domain_total_amount,
       domain_rsya_amount,
       domain_rsya_rate,
       counters_rate,
       goals_rate,
       click_visit_rate,
       metrika_amount,
       metrika_and_goals_amount,
       autobudget_avg_amount,
       cpc_video_amount,
       mobile_content_amount,
       performance_amount,
       product_gallery_amount,
       k50_effective_actions_rate,
       k50_efficient_amount,
       retargeting_amount,
       autotarget_search_amount
FROM $rewards AS r
INNER JOIN `//home/direct/db/clients` AS c ON c.ClientID = r.client_id
INNER JOIN `//home/direct/db/users` AS u1 ON u1.uid = c.chief_uid
LEFT JOIN `//home/direct/db/users` AS u2 ON u2.uid = c.agency_uid
ORDER BY client_id, cid
