PRAGMA yt.Pool = ?;--test_value='default';

$agency_id = ?;--test_value=62197708;
$date_from = ?;--test_value="2021-12-01";
$date_to = ?;--test_value="2022-01-31";
$show_all_client = ?;--test_value=1;
$table_name = ?;--test_value="report_base";
--Пример запроса для base: https://yql.yandex-team.ru/Operations/YgQlqgVK8PTmj7-92cJs4-yrthyzLGBjLvrz5OZcYYY=
--Пример запроса для premium: https://yql.yandex-team.ru/Operations/YgTky65OD3u9OMDCu-ptX1pGLmdbK0smETeMMW13d2s=
--Пример запроса для aggregator: https://yql.yandex-team.ru/Operations/YgTlJK5OD3u9OMEFzlqGXx_4qQWFzi6Qtv1Um8z4cNs=

$report_table = "//home/search-research/yateika/rewards/ga-247/" || $table_name;

$rewards = (
    SELECT
        String::JoinFromList(AGGREGATE_LIST_DISTINCT(contract_eids), ",") AS contract_eids,
        r.client_id AS client_id,
        String::JoinFromList(AGGREGATE_LIST_DISTINCT(CAST(client_name AS String)), "; ") AS client_name,
        r.cid AS cid,
        String::JoinFromList(AGGREGATE_LIST_DISTINCT(cid_name), "; ") AS campaign_name,
        SUM(NVL(show_amount, 0)) AS total_amount,
        SUM(NVL(outstream_show_amount, 0)) AS outstream_amount  --значение не используется для aggregator
    FROM $report_table AS r
    WHERE `date` BETWEEN $date_from and $date_to
        AND agency_id = $agency_id
        AND media_flag
        AND ($show_all_client = 1 OR r.client_id IN ParseFile("Int64", "client_ids.txt"))
    GROUP BY r.client_id, r.cid
);

SELECT contract_eids,
       r.client_id AS client_id,
       u1.login AS client_login,
       client_name,
       u2.login AS representative_login,
       cid,
       campaign_name,
       total_amount,
       outstream_amount
FROM $rewards AS r
         INNER JOIN `//home/direct/db/clients` AS c ON c.ClientID = r.client_id
         INNER JOIN `//home/direct/db/users` AS u1 ON u1.uid = c.chief_uid
         LEFT JOIN `//home/direct/db/users` AS u2 ON u2.uid = c.agency_uid
ORDER BY client_id, cid
