PRAGMA yt.Pool = ?;--test_value='default';

$agency_id = ?;--test_value=350487;
$date_from = ?;--test_value="201903";
$date_to = ?;--test_value="201903";
$show_all_client = ?;--test_value=1;

$is_during_period = ($table_name) -> {
    RETURN ($table_name BETWEEN $date_from AND $date_to) AND LEN($table_name)=6;
};
$base_folder ="//home/balance/prod/yb-ar/domain-grades-report";
$stat = (
  select CASE WHEN domain=='' or domain is null THEN 'технический домен' ELSE domain END as domain,client_id,domain_grade,total_by_client as total,TableName() as month
  FROM FILTER($base_folder, $is_during_period)
  where agency_id = $agency_id
  AND ($show_all_client = 1 OR client_id IN ParseFile("Int64", "client_ids.txt"))
);
$prof_20_base_folder ="//home/balance/prod/yb-ar/rewards/reports/direct/2020-prof_20-m-prof/domain-grades-report";
$prof_20_stat = (
  select CASE WHEN domain=='' or domain is null THEN 'технический домен' ELSE domain END as domain,client_id,total_by_client_rsya as total_rsya,TableName() as month
  FROM FILTER($prof_20_base_folder, $is_during_period)
  where agency_id = $agency_id
  AND ($show_all_client = 1 OR client_id IN ParseFile("Int64", "client_ids.txt"))
);

select NVL(Url::PunycodeToHostName(r.domain),r.domain) as domain, r.client_id as client_id, domain_grade, total, total_rsya, r.month as month, u.fio as client_name
FROM $stat as r
inner join `//home/direct/db/clients` as cl on cl.ClientID = r.client_id
inner join `//home/direct/db/users` as u on cl.chief_uid = u.uid
left outer join $prof_20_stat as p on p.domain=r.domain and p.client_id=r.client_id and p.month=r.month
order by domain,client_id
