$dest_table = ?;
$chtracking_log_table = ?;

$pid_with_type = (
    select distinct
        vsg.pid as pid, p.adgroup_type as type
    from like(`home/direct/mysql-sync/current`, `ppc:%`, `straight/video_segment_goals`) as vsg
    join like(`home/direct/mysql-sync/current`, `ppc:%`, `straight/phrases`) as p
    on vsg.pid = p.pid
);

insert into $dest_table
with truncate
    select distinct
        groupexportid,
        `action`,
        uniqid
    from $chtracking_log_table
    where CAST(groupexportid as Int64) in (
        select pid from $pid_with_type
        where type in ('cpm_banner', 'cpm_video', 'cpm_audio', 'cpm_indoor', 'cpm_outdoor')
    )
      and `action` in ('start', 'first-quartile', 'midpoint', 'third-quartile', 'complete')
    order by groupexportid, `action`;
