$fromDb = (
    SELECT client_phone_id, permalink, ClientID, aggregate_list(uid) AS uids
    FROM LIKE(`//home/direct/mysql-sync/current`, `ppc:%`, `straight/client_phones`) AS cp
    JOIN LIKE(`//home/direct/mysql-sync/current`, `ppc:%`, `straight/users`) AS u ON u.ClientID = cp.ClientID
    GROUP BY (cp.client_phone_id as client_phone_id, cp.permalink_id as permalink, u.ClientID as ClientID)
);

$fromAcl = (
    SELECT company_permalink, aggregate_list(user_id) AS uids
    FROM `home/sprav/tycoon/production/snapshot/combined_company_acl` AS acl
    WHERE object_type = "company" AND (object_role = "owner" or object_role = "delegate")
    GROUP BY company_permalink
);

SELECT client_phone_id, ClientID
FROM $fromDb AS db JOIN $fromAcl AS acl ON db.permalink = acl.company_permalink
WHERE DictLength(SetIntersection(ToSet(db.uids), ToSet(acl.uids))) = 0;