
PRAGMA yt.MaxRowWeight = "32M";
PRAGMA yson.DisableStrict;

-- Parameters:
--   0: path
--   1: last update time
-- Field names and order:
--   1: PageID
--   2: ProductType
--   3: Domain
--   4: PageCaption
--   5: IsYandexPage
--   6: IsDeleted
--   7: Blocks
--   8: UpdateTime
--   9: Login
$rtbBlocksDictSource = ($JsonData) -> {
    return Yson::ConvertToDict(Yson::Lookup($JsonData, "RtbBlocks"));
};

$src_table = ?; -- '//home/yabs/dict/EditPage'
$update_time = ?; -- 1562291473;


$extractBlockIsHidden = ($JsonBlockData) -> {
    $isHidden = Yson::ConvertToString(Yson::YPath($JsonBlockData, "/CustomBlockData/IsHidden"));
    return $isHidden IS NOT NULL AND $isHidden == "1";
};

$commonBlocks = ($JsonData) -> {
    return ListMap(DictItems($rtbBlocksDictSource($JsonData)), ($rtbBlockTuple) -> {
        return AsStruct(
            $rtbBlockTuple.0 as Id,
            Yson::Lookup($rtbBlockTuple.1, "BlockCaption") as BlockCaption,
            Yson::Lookup($rtbBlockTuple.1, "Sizes") as Sizes
        );
    })
};

$outdoorBlocks = ($JsonData) -> {
    return ListMap(DictItems($rtbBlocksDictSource($JsonData)), ($rtbBlockTuple) -> {
        return AsStruct(
            $rtbBlockTuple.0 as Id,
            Yson::Lookup($rtbBlockTuple.1, "BlockCaption") as BlockCaption,
            Yson::Lookup($rtbBlockTuple.1, "Sizes") as Sizes,
            Yson::YPath($rtbBlockTuple.1, "/CustomBlockData/dooh/address") as Address,
            Yson::YPath($rtbBlockTuple.1, "/CustomBlockData/dooh/gps") as GPS,
            Yson::YPath($rtbBlockTuple.1, "/CustomBlockData/dooh/resolution") as Resolution,
            Yson::YPath($rtbBlockTuple.1, "/CustomBlockData/dooh/facility_type") as FacilityType,
            Yson::YPath($rtbBlockTuple.1, "/CustomBlockData/dooh/direction") as Direction,
            Yson::YPath($rtbBlockTuple.1, "/CustomBlockData/dooh/width") as Width,
            Yson::YPath($rtbBlockTuple.1, "/CustomBlockData/dooh/height") as Height,
            Yson::YPath($rtbBlockTuple.1, "/CustomBlockData/dooh/min_duration") as MinDuration,
            Yson::YPath($rtbBlockTuple.1, "/CustomBlockData/dooh/photo_list") as PhotoList,
            $extractBlockIsHidden($rtbBlockTuple.1) as IsHidden
        );
    })
};

$indoorBlocks = ($JsonData) -> {
    return ListMap(DictItems($rtbBlocksDictSource($JsonData)), ($rtbBlockTuple) -> {
        return AsStruct(
            $rtbBlockTuple.0 as Id,
            Yson::Lookup($rtbBlockTuple.1, "BlockCaption") as BlockCaption,
            Yson::Lookup($rtbBlockTuple.1, "Sizes") as Sizes,
            Yson::YPath($rtbBlockTuple.1, "/CustomBlockData/dooh/address") as Address,
            Yson::YPath($rtbBlockTuple.1, "/CustomBlockData/dooh/gps") as GPS,
            Yson::YPath($rtbBlockTuple.1, "/CustomBlockData/dooh/resolution") as Resolution,
            Yson::YPath($rtbBlockTuple.1, "/CustomBlockData/dooh/facility_type") as FacilityType,
            Yson::YPath($rtbBlockTuple.1, "/CustomBlockData/dooh/zone_category") as ZoneCategory,
            Yson::YPath($rtbBlockTuple.1, "/CustomBlockData/dooh/aspect_ratio") as AspectRatio,
            Yson::YPath($rtbBlockTuple.1, "/CustomBlockData/dooh/photo_list") as PhotoList,
            $extractBlockIsHidden($rtbBlockTuple.1) as IsHidden
        );
    })
};

$extractProductId = ($JsonData) -> {return Yson::LookupString($JsonData, "ProductID")};
$extractProductType = ($JsonData) -> {return Yson::LookupString($JsonData, "ProductType")};
$extractDomain = ($JsonData) -> {return Yson::LookupString($JsonData, "Domain")};
$extractPageCaption = ($JsonData) -> {return Yson::LookupString($JsonData, "PageCaption")};
$extractIsYandexPage = ($JsonData) -> {return Yson::LookupString($JsonData, "IsYandexPage") == "1"};
$extractIsDeleted = ($JsonData) -> {return Yson::LookupString($JsonData, "State") != "1"};
$extractIsTesting = ($JsonData) -> {return Yson::LookupString($JsonData, "IsTesting") == "1"};
$extractLogin = ($JsonData) -> {return Yson::LookupString($JsonData, "Login")};
$extractCommonBlocksSerialized = ($JsonData) -> {return Yson::SerializeJson(Yson::From($commonBlocks($JsonData)))};
$extractOutdoorBlocksSerialized = ($JsonData) -> {return Yson::SerializeJson(Yson::From($outdoorBlocks($JsonData)))};
$extractIndoorBlocksSerialized = ($JsonData) -> {return Yson::SerializeJson(Yson::From($indoorBlocks($JsonData)))};
$extractMirrors = ($JsonData) -> {return Yson::LookupString($JsonData, "Mirrors")};

SELECT
  PageID,
  $extractProductType(JsonData) AS ProductType,
  $extractDomain(JsonData) AS Domain,
  $extractPageCaption(JsonData) AS PageCaption,
  $extractIsYandexPage(JsonData) AS IsYandexPage,
  $extractIsDeleted(JsonData) AS IsDeleted,
  $extractIsTesting(JsonData) AS IsTesting,
  $extractMirrors(JsonData) AS Mirrors,
  CASE
    WHEN $extractProductType(JsonData) == "outdoor" THEN ToBytes($extractOutdoorBlocksSerialized(JsonData))
    WHEN $extractProductType(JsonData) == "indoor" THEN ToBytes($extractIndoorBlocksSerialized(JsonData))
    ELSE ToBytes($extractCommonBlocksSerialized(JsonData))
  END AS Blocks,
  UpdateTime,
  $extractLogin(JsonData) as Login
FROM (
  SELECT PageID,
  MAX(UpdateTime) as UpdateTime,
  MAX_BY(Data, UpdateTime) as Data,
  MAX_BY(Yson::Serialize(Yson::ParseJson(Data)), UpdateTime) as JsonData
  FROM
    (SELECT * FROM $src_table WHERE UpdateTime >= $update_time)
  GROUP BY PageID
);
